% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permanova.R
\name{pseudoF}
\alias{pseudoF}
\title{Compute pseudo-F statistic for PERMANOVA}
\usage{
pseudoF(z = NULL, D = NULL, y)
}
\arguments{
\item{z}{Object matrix; used to build distance matrix d; d is prioritized}

\item{D}{Distance matrix; if NULL, obtain from mat using Euclidean distance}

\item{y}{Vector of treatments}
}
\value{
pseudo-F value
}
\description{
Compute pseudo-F statistic for PERMANOVA
}
\examples{
require(phyloseq)
data(microbiome)
D <- distance(microbiome, method = 'wunifrac') # requires phyloseq package
y <- sample_data(microbiome)$Treatment
pseudoF(D = D, y = y)
}
