% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmds.R
\name{pairByRank}
\alias{pairByRank}
\title{Get p-value matrix}
\usage{
pairByRank(z, D, y)
}
\arguments{
\item{z}{Lower dimension representation}

\item{D}{Original distance matrix}

\item{y}{Treatment vector}
}
\value{
pseudo-F values matrix
1st col of original data, 2nd col of reduced dim
}
\description{
Get p-value matrix
}
\examples{
require(phyloseq)
data(microbiome)
D <- distance(microbiome, method = 'wunifrac') # requires phyloseq package
y <- sample_data(microbiome)$Treatment
z0 <- cmdscale(d = D)
pairByRank(z = z0, D = D, y = y)
}
