#' Microbiome dataset
#'
#' A phyloseq-class object representing an example microbial community dataset. The dataset consists of 36 microbiome samples, half of which were co-cultured with their diatom host (Phaeodactylum tricornutum). Each microbiome comprises 72 bacterial taxa identified by amplicon sequence variants (ASVs) of the 16S rRNA gene. ASV counts represent relative abundances after applying the cumulative sum scaling (CSS) method.
#'
#' @format A phyloseq-class object.
#' @source Data derived from an experimental study on host-microbe interactions.
#' @references
#' Kim H., Kimbrel J.A., Vaiana C.A., Wollard J.R., Mayali X., Buie C.R. (2022).
#' Bacterial response to spatial gradients of algal-derived nutrients in a porous microplate.
#' \emph{The ISME Journal}, 16(4), 1036–1045.
#' \doi{10.1038/s41396-021-01163-4}
#' @return A phyloseq-class object consisting of relative abundance table, taxonomy table, sample dataframe, and phylogenetic tree
#' @usage data(microbiome)
"microbiome"
