% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakGeneCor_parse.R
\name{plot_peakGeneCor}
\alias{plot_peakGeneCor}
\title{plot_peakGeneCor}
\usage{
plot_peakGeneCor(
  mmAnnoCor,
  select_gene,
  addLine = TRUE,
  addFullInfo = TRUE,
  sigShow = c("pvalue", "padj", "qvalue")
)
}
\arguments{
\item{mmAnnoCor}{the annotated GRange object from peakGeneCor or enhancerPromoterCor}

\item{select_gene}{a gene_id which you want to show}

\item{addLine}{whether add cor line}

\item{addFullInfo}{whether add full feature info on plot}

\item{sigShow}{one of 'pvalue' 'padj' 'qvalue'}
}
\value{
ggplot2 object
}
\description{
plot_peakGeneCor
}
\examples{

if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    data("RNA_normCount")
    data("ATAC_normCount")
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))
    peak_path <- system.file("extdata", "ATAC.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)[1:100]
    mmAnno <- mm_geneScan(peak_GR, Txdb)

    ATAC_colData <- data.frame(
        row.names = colnames(ATAC_normCount),
        type = gsub("_R[0-9]", "", colnames(ATAC_normCount))
    )

    integrate_replicates(ATAC_normCount, ATAC_colData) -> ATAC_normCount_merge
    RNA_colData <- data.frame(
        row.names = colnames(RNA_normCount),
        type = gsub("_R[0-9]", "", colnames(RNA_normCount))
    )
    integrate_replicates(RNA_normCount, RNA_colData) -> RNA_normCount_merge
    mmAnnoCor <- peakGeneCor(
        mmAnno = mmAnno,
        peakScoreMt = ATAC_normCount_merge,
        geneScoreMt = RNA_normCount_merge,
        parallel = FALSE
    )

    plot_peakGeneCor(mmAnnoCor, select_gene = "AT5G01010")

}
}
