% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmPeakAnno_parse.R
\name{plot_annoDistance}
\alias{plot_annoDistance}
\title{plot_annoDistance}
\usage{
plot_annoDistance(mmAnno, quantile = c(0.01, 0.99))
}
\arguments{
\item{mmAnno}{the annotated GRange object from mm_nearestGene}

\item{quantile}{the quantile of distanceToTSS you want to show}
}
\value{
a ggplot2 object
}
\description{
plot the distance distribution of mmAnno from mm_nearestGene, which helps you
decide whehter your TF is promoter or enhancer dominant
}
\examples{
if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))

    peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)
    peakAnno <- mm_nearestGene(peak_GR, Txdb)
    plot_annoDistance(peakAnno)

}
}
