% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmPeakAnno.R
\name{mm_nearestGene}
\alias{mm_nearestGene}
\title{mm_nearestGene}
\usage{
mm_nearestGene(peak_GR, Txdb, reportGeneInfo = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{peak_GR}{peak GRange with a column named feature_id representing you
peak name}

\item{Txdb}{Txdb}

\item{reportGeneInfo}{whether you want to report full gene info}

\item{verbose}{whether you want to report detailed running message}

\item{...}{additional arguments in distanceToNearest}
}
\value{
Granges object with annotated info
}
\description{
Annotate peaks using nearest gene mode, which means every peak only have one
related gene.
}
\examples{

if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))

    peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)
    peakAnno <- mm_nearestGene(peak_GR, Txdb)
    peakAnno
}
}
