% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmPeakAnno.R
\name{mm_geneBound}
\alias{mm_geneBound}
\title{mm_geneBound}
\usage{
mm_geneBound(peak_GR, Txdb, input_genes, verbose = TRUE, ...)
}
\arguments{
\item{peak_GR}{peak GRange with a column named feature_id representing you peak name}

\item{Txdb}{Txdb}

\item{input_genes}{a character vector which represent genes set
which you want to find related peak for}

\item{verbose}{whether you want to report detailed running message}

\item{...}{additional arguments in distanceToNearest}
}
\value{
data.frame with three column: related peak id, your input gene id,
and distance
}
\description{
find related peaks of your input genes, which is useful when you want to plot
volcano plot or heatmap of peaks.
}
\examples{
if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))
    peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)
    peak_pair <- mm_geneBound(peak_GR, Txdb, c("AT5G01015", "AT5G67570"))
    peak_pair
}
}
