% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findIT_TTpair_enrichFisher_parse.R
\name{jaccard_findIT_enrichFisher}
\alias{jaccard_findIT_enrichFisher}
\title{jaccard_findIT_enrichFisher}
\usage{
jaccard_findIT_enrichFisher(
  input_feature_id,
  peak_GR,
  TF_GR_database,
  input_TF_id
)
}
\arguments{
\item{input_feature_id}{a character vector which represent peaks set
which you want to find influential TF for (same as your find_IT_enrichFisher parameter)}

\item{peak_GR}{a GRange object represent your whole feature location with a
column named feature_id, which your input_feature_id should a part of it.}

\item{TF_GR_database}{TF peak GRange with a column named TF_id representing you TF name}

\item{input_TF_id}{TF_id which you want to calculate jaccard index for}
}
\value{
jaccard similarity matrix
}
\description{
jaccard_findIT_enrichFisher
}
\examples{
data("test_featureSet")
peak_path <- system.file("extdata", "ATAC.bed.gz", package = "FindIT2")
peak_GR <- loadPeakFile(peak_path)

ChIP_peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
ChIP_peak_GR <- loadPeakFile(ChIP_peak_path)
ChIP_peak_GR$TF_id <- "AT1G28300"
result_findIT_enrichFisher <- findIT_enrichFisher(
    input_feature_id = test_featureSet,
    peak_GR = peak_GR,
    TF_GR_database = ChIP_peak_GR
)

jaccard_findIT_enrichFisher(
    input_feature_id = test_featureSet,
    peak_GR = peak_GR,
    TF_GR_database = ChIP_peak_GR,
    input_TF_id = result_findIT_enrichFisher$TF_id[1]
)
}
