% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_influential_TF.R
\name{findIT_enrichWilcox}
\alias{findIT_enrichWilcox}
\title{findIT_enrichWilcox}
\usage{
findIT_enrichWilcox(
  input_feature_id,
  peak_GR,
  TF_GR_database,
  background_peaks = NULL,
  background_number = 3000
)
}
\arguments{
\item{input_feature_id}{a character vector which represent peaks set
which you want to find influential TF for}

\item{peak_GR}{a GRange object represent your whole feature location with a
column named feature_id, which your input_feature_id should a part of it.}

\item{TF_GR_database}{TF peak GRange with a column named TF_id representing you TF name}

\item{background_peaks}{a character vector which represent background peak set.
If you do not assign background peaks, program will sample
background_number peaks as background peaks from all feature_id in your peak_GR}

\item{background_number}{background peaks number}
}
\value{
data.frame
}
\description{
findIT_enrichWilcox
}
\examples{
data("test_featureSet")
peak_path <- system.file("extdata", "ATAC.bed.gz", package = "FindIT2")
peak_GR <- loadPeakFile(peak_path)
ChIP_peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
ChIP_peak_GR <- loadPeakFile(ChIP_peak_path)
ChIP_peak_GR$TF_id <- "AT1G28300"

result_findIT_enrichWilcox <- findIT_enrichWilcox(
    input_feature_id = test_featureSet,
    peak_GR = peak_GR,
    TF_GR_database = ChIP_peak_GR
)
}
