% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_influential_TF.R
\name{findIT_MARA}
\alias{findIT_MARA}
\title{findIT_MARA}
\usage{
findIT_MARA(
  input_feature_id,
  peak_GR,
  peakScoreMt,
  TF_GR_database,
  log = TRUE,
  meanScale = TRUE,
  output = c("coef", "cor"),
  verbose = TRUE
)
}
\arguments{
\item{input_feature_id}{a character vector which represent peaks set
which you want to find influential TF for}

\item{peak_GR}{a GRange object represent your whole feature location with a
column named feature_id, which your input_feature_id should a part of it.}

\item{peakScoreMt}{peak count matrix.}

\item{TF_GR_database}{TF peak GRange with a column named TF_id representing you TF name.
If you have TF_score column, MARA will consider it. otherwise, MARA will consider each hit is 1.}

\item{log}{whether you want to log your peakScoreMt}

\item{meanScale}{whether you want to mean-centered per row}

\item{output}{one of 'coef' and 'cor'. Default is coef}

\item{verbose}{whether you want to report detailed running message}
}
\value{
a data.frame
}
\description{
findIT_MARA
}
\examples{

data("ATAC_normCount")
data("test_featureSet")

peak_path <- system.file("extdata", "ATAC.bed.gz", package = "FindIT2")
peak_GR <- loadPeakFile(peak_path)

ChIP_peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
ChIP_peak_GR <- loadPeakFile(ChIP_peak_path)
ChIP_peak_GR$TF_id <- "AT1G28300"

set.seed(20160806)

result_findIT_MARA <- findIT_MARA(
    input_feature_id = test_featureSet,
    peak_GR = peak_GR,
    peakScoreMt = ATAC_normCount,
    TF_GR_database = ChIP_peak_GR
)

}
