% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim3q_filter.R
\name{trim3q_filter}
\alias{trim3q_filter}
\title{Filter sequences with low quality in 3' tails}
\usage{
trim3q_filter(
  input,
  rm.3qual,
  q_format = NULL,
  check.encod = TRUE,
  remove_zero = TRUE
)
}
\arguments{
\item{input}{\code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} object}

\item{rm.3qual}{Quality threshold for 3' tails}

\item{q_format}{Quality format used for the file, 
as returned by check_encoding}

\item{check.encod}{Check the encoding of the sequence? This argument 
is incompatible with q_format. Default TRUE}

\item{remove_zero}{Remove zero-length sequences?}
}
\value{
Filtered \code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} 
object
}
\description{
The program removes from the 3' tails of the sequences 
a set of nucleotides showing a quality < a threshold value in a 
ShortReadQ object
}
\examples{

require('Biostrings')
require('ShortRead')

# create 6 sequences of width 20
set.seed(10)
input <- random_seq(6, 20)

# create qualities of width 15 and paste to qualities
# of length 5 used for the tails.
# for two of the sequences, put low qualities in tails

set.seed(10)
my_qual <- random_qual(c(30,40), slength = 6, swidth = 15, 
encod = 'Sanger')

set.seed(10)
tails <-   random_qual(c(30,40), slength = 6, swidth = 5, 
 encod = 'Sanger')
 
set.seed(10)
tails[2:3] <- random_qual(c(3, 20), slength = 2, 
swidth = 5,  encod = 'Sanger')
my_qual <- paste0(my_qual, tails)
input_q <- BStringSet(my_qual)
# create names
input_names <- seq_names(6)

# create ShortReadQ object
my_read <- ShortReadQ(sread = input,
quality = input_q, id = input_names)

# apply the filter 
filtered <- trim3q_filter(my_read, rm.3qual = 28)

# look at the trimmed sequences
sread(filtered)
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
