% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{inject_letter_random}
\alias{inject_letter_random}
\title{Inject a letter in a set of sequences at random positions}
\usage{
inject_letter_random(
  my_seq,
  how_many_seqs = NULL,
  how_many_letters = NULL,
  letter = "N"
)
}
\arguments{
\item{my_seq}{character vector with sequences to inject}

\item{how_many_seqs}{How many sequences pick to inject Ns. 
An interval [min_s, max_s] with min_s minimum 
and max_s maximum sequences can be passed. In this case, 
a value is picked from the interval. 
If NULL, a random value within the interval [1, length(my_seq)] is picked.}

\item{how_many_letters}{How many times inject the letter 
in the i sequences that are going to be injected. An interval [min_i max_i]
can be passed. In this case, a value is randomly 
picked for each sequence i. This value represents the number of times
that the letter will be injected in the sequence i.
If NULL, a random value within the interval [1, width(my_seq[i])] 
is picked for each sequence i.}

\item{letter}{Letter to inject. Default: 'N'}
}
\value{
character vector
}
\description{
Inject a letter in a set of sequences at random positions
}
\examples{

# For reproducible examples, make a call to set.seed before 
# running each random function

set.seed(10)
s <- random_seq(slength = 10, swidth = 20)

set.seed(10)
s <- inject_letter_random(s, how_many_seqs = 1:30, how_many= 2:10)

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
