% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{results,FraserDataSet-method}
\alias{results,FraserDataSet-method}
\alias{aberrant,FraserDataSet-method}
\title{Extracting results and aberrant splicing events}
\usage{
\S4method{results}{FraserDataSet}(
  object,
  sampleIDs = samples(object),
  padjCutoff = 0.1,
  deltaPsiCutoff = 0.1,
  rhoCutoff = NA,
  aggregate = FALSE,
  collapse = FALSE,
  minCount = 5,
  psiType = psiTypes,
  geneColumn = "hgnc_symbol",
  all = FALSE,
  returnTranscriptomewideResults = TRUE,
  additionalColumns = NULL,
  BPPARAM = bpparam()
)

\S4method{aberrant}{FraserDataSet}(
  object,
  type = fitMetrics(object),
  padjCutoff = 0.1,
  deltaPsiCutoff = 0.1,
  minCount = 5,
  rhoCutoff = NA,
  by = c("none", "sample", "feature"),
  aggregate = FALSE,
  geneColumn = "hgnc_symbol",
  subsetName = NULL,
  all = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{\link{FraserDataSet}} object}

\item{sampleIDs}{A vector of sample IDs for which results should be 
retrieved}

\item{padjCutoff}{The FDR cutoff to be applied or NA if not requested.}

\item{deltaPsiCutoff}{The cutoff on delta psi or NA if not requested.}

\item{rhoCutoff}{The cutoff value on the fitted rho value 
(overdispersion parameter of the betabinomial) above which 
junctions are filtered}

\item{aggregate}{If TRUE the returned object is aggregated to the feature 
level (i.e. gene level).}

\item{collapse}{Only takes effect if \code{aggregate=TRUE}. 
If TRUE, collapses results across the different psi 
types to return only one row per feature (gene) and sample.}

\item{minCount}{The minimum count value of the total coverage of an intron 
to be considered as significant.
result}

\item{psiType}{The psi types for which the results should be retrieved.}

\item{geneColumn}{The column name of the column that has the gene annotation 
that will be used for gene-level pvalue computation.}

\item{all}{By default FALSE, only significant introns (or genes) are listed 
in the results. If TRUE, results are assembled for all 
samples and introns/genes regardless of significance.}

\item{returnTranscriptomewideResults}{If FDR corrected pvalues for subsets 
of genes of interest have been calculated, this parameter 
indicates whether additionally the transcriptome-wide results 
should be returned as well (default), or whether only results 
for those subsets should be retrieved.}

\item{additionalColumns}{Character vector containing the names of additional 
columns from mcols(fds) that should appear in the result table 
(e.g. ensembl_gene_id). Default is \code{NULL}, so no additional columns 
are included.}

\item{BPPARAM}{The BiocParallel parameter.}

\item{type}{Splicing type (psi5, psi3 or theta)}

\item{by}{By default \code{none} which means no grouping. But if 
\code{sample} or \code{feature} is specified the sum by 
sample or feature is returned}

\item{subsetName}{The name of a subset of genes of interest for which FDR 
corrected pvalues were previously computed. Those FDR values 
on the subset will then be used to determine aberrant status. 
Default is NULL (using transcriptome-wide FDR corrected pvalues).}

\item{...}{Further arguments can be passed to the method. If "n",
"padjVals", "dPsi" or "rhoVals" are given, the values of those 
arguments are used to define the aberrant events.}
}
\value{
For \code{results}: GRanges object containing significant results.
    For \code{aberrant}: Either a of logical values of size 
    introns/genes x samples if "by" is NA or a vector with the 
    number of aberrant events per sample or feature depending on 
    the vaule of "by"
}
\description{
The result function extracts the results from the given analysis object
based on the given options and cutoffs. The aberrant function extracts 
aberrant splicing events based on the given cutoffs.
}
\examples{
# get data, fit and compute p-values and z-scores
fds <- createTestFraserDataSet()

# extract results: for this example dataset, no cutoffs are used to
# show the output of the results function
res <- results(fds, all=TRUE)
res

# aggregate the results by genes (gene symbols need to be annotated first 
# using annotateRanges() function)
results(fds, padjCutoff=NA, deltaPsiCutoff=0.1, aggregate=TRUE)

# aggregate the results by genes and collapse over all psi types to obtain 
# only one row per gene in the results table 
results(fds, padjCutoff=NA, deltaPsiCutoff=0.1, aggregate=TRUE, 
        collapse=TRUE)

# get aberrant events per sample: on the example data, nothing is aberrant
# based on the adjusted p-value
aberrant(fds, type="jaccard", by="sample")

# get aberrant events per gene (first annotate gene symbols)
fds <- annotateRangesWithTxDb(fds)
aberrant(fds, type="jaccard", by="feature", padjCutoff=NA, aggregate=TRUE)
        
# find aberrant junctions/splice sites
aberrant(fds, type="jaccard")

# retrieve results limiting FDR correction to only a subset of genes
# first, we need to create a list of genes per sample that will be tested
geneList <- list('sample1'=c("TIMMDC1"), 'sample2'=c("MCOLN1"))
fds <- calculatePadjValues(fds, type="jaccard", 
                 subsets=list("exampleSubset"=geneList))
results(fds, all=TRUE, returnTranscriptomewideResults=FALSE)

}
