% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveHDF5Objects.R
\name{loadFraserDataSet}
\alias{loadFraserDataSet}
\alias{saveFraserDataSet}
\title{Loading/Saving FraserDataSets}
\usage{
loadFraserDataSet(dir, name = NULL, file = NULL, upgrade = FALSE)

saveFraserDataSet(fds, dir = NULL, name = NULL, rewrite = FALSE)
}
\arguments{
\item{dir}{A path where to save the objects (replaces the working directory)}

\item{name}{The analysis name of the project (saved within the `dir`)}

\item{file}{The file path to the fds-object.RDS file that should be loaded.}

\item{upgrade}{Should the version of the loaded object be updated?}

\item{fds}{A FraserDataSet object ot be saved}

\item{rewrite}{logical if the object should be rewritten. This makes sense if
you have filtered or subsetted the object and want to save only
the subsetted version}
}
\value{
FraserDataSet
}
\description{
This is a convenient function to load and save a FraserDataSet object.
It looks and saves the FraserDataSet objects and HDF5 files on disk under
the given working dir. Internally it uses HDF5 files for all assays.
}
\examples{
fds <- createTestFraserSettings()
name(fds) <- "saveing_test"

# make sure the object is saved to disc
dontWriteHDF5(fds) <- FALSE
fdsSaved <- saveFraserDataSet(fds)
fdsSaved

# load object from disc
fdsLoaded <- loadFraserDataSet(dir=workingDir(fds), name=name(fds))
fdsLoaded

all.equal(fdsSaved, fdsLoaded)

}
