% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSimulatedDataset.R
\name{injectOutliers}
\alias{injectOutliers}
\title{Inject artificial outliers in an existing fds}
\usage{
injectOutliers(
  fds,
  type = psiTypes,
  freq = 0.001,
  minDpsi = 0.2,
  minCoverage = 2,
  deltaDistr = "uniformDistr",
  verbose = FALSE,
  method = c("samplePSI", "meanPSI", "simulatedPSI"),
  BPPARAM = bpparam()
)
}
\arguments{
\item{fds}{FraserDataSet}

\item{type}{The psi type}

\item{freq}{The injection frequency.}

\item{minDpsi}{The minimal delta psi with which outliers will be injected.}

\item{minCoverage}{The minimal total coverage (i.e. N) required for a 
junction to be considered for injection of an outlier.}

\item{deltaDistr}{The distribution from which the delta psi value of 
the injections is drawn (default: uniform distribution).}

\item{verbose}{Should additional information be printed during computation?}

\item{method}{Defines by which method the new psi of injections is computed, 
i.e. to which value the delta psi of the injection is added: "meanPSI" for 
adding to the mean psi of the junction over all samples or "samplePSI" to 
add to the psi value of the junction in the specific sample. "simulatedPSI" 
is only possible if a simulated dataset is used.}

\item{BPPARAM}{A BiocParallel object to run the computation in parallel}
}
\value{
FraserDataSet
}
\description{
Inject artificial outliers in an existing fds
}
\examples{
# A generic dataset
fds <- makeSimulatedFraserDataSet()
fds <- calculatePSIValues(fds)
fds <- injectOutliers(fds, minDpsi=0.2, freq=1E-3)
}
