% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitCorrectionMethods.R
\name{fit}
\alias{fit}
\alias{fit.FraserDataSet}
\title{Fitting the denoising autoencoder}
\usage{
\method{fit}{FraserDataSet}(
  object,
  implementation = c("PCA", "PCA-BB-Decoder", "AE", "AE-weighted", "PCA-BB-full",
    "fullAE", "PCA-regression", "PCA-reg-full", "PCA-BB-Decoder-no-weights", "BB"),
  q,
  type = psiTypes,
  rhoRange = c(-30, 30),
  weighted = FALSE,
  noiseAlpha = 1,
  convergence = 1e-05,
  iterations = 15,
  initialize = TRUE,
  control = list(),
  BPPARAM = bpparam(),
  nSubset = 15000,
  minDeltaPsi = 0.1,
  ...
)
}
\arguments{
\item{object}{A \code{\link{FraserDataSet}} object}

\item{implementation}{The method that should be used to correct for 
confounders.}

\item{q}{The encoding dimensions to be used during the fitting proceadure.
Should be fitted using \code{\link{estimateBestQ}} if unknown.
If a named vector is provided it is used for the different
splicing types.}

\item{type}{The type of PSI (jaccard, psi5, psi3 or theta for theta/splicing 
efficiency)}

\item{rhoRange}{Defines the range of values that rho parameter from the 
beta-binomial distribution is allowed to take. For very small values of rho, 
the loss can be instable, so it is not recommended to allow rho < 1e-8.}

\item{weighted}{If TRUE, the weighted implementation of the autoencoder is 
used}

\item{noiseAlpha}{Controls the amount of noise that is added for the 
denoising autoencoder.}

\item{convergence}{The fit is considered to have converged if the difference 
between the previous and the current loss is smaller than this threshold.}

\item{iterations}{The maximal number of iterations. When the autoencoder has 
not yet converged after these number of iterations, the fit stops anyway.}

\item{initialize}{If FALSE and a fit has been previoulsy run, the values 
from the previous fit will be used as initial values. If TRUE, 
(re-)initialization will be done.}

\item{control}{List of control parameters passed on to optim().}

\item{BPPARAM}{the BiocParallel parameters for the parallelization}

\item{nSubset}{The size of the subset to be used in fitting if subsetting is
used.}

\item{minDeltaPsi}{Minimal delta psi of an intron to be be considered a 
variable intron.}

\item{...}{Currently not used}
}
\value{
\code{\link{FraserDataSet}}
}
\description{
This method corrects for confounders in the data and 
fits a beta-binomial distribution to the introns/splice sites.

For more details please see \code{\link{FRASER}}.
}
\seealso{
\code{\link{FRASER}}
}
