% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_encoding_dimensions.R
\name{estimateBestQ}
\alias{estimateBestQ}
\title{Find optimal encoding dimension}
\usage{
estimateBestQ(
  fds,
  type = "jaccard",
  useOHT = TRUE,
  implementation = "PCA",
  q_param = getEncDimRange(fds),
  noise_param = 0,
  minDeltaPsi = 0.1,
  iterations = 5,
  setSubset = 50000,
  injectFreq = 0.01,
  BPPARAM = bpparam(),
  internalThreads = 1,
  plot = TRUE,
  delayed = ifelse(ncol(fds) <= 300, FALSE, TRUE),
  ...
)
}
\arguments{
\item{fds}{A \code{\link{FraserDataSet}} object}

\item{type}{The type of PSI (jaccard, psi5, psi3 or theta for theta/splicing 
efficiency)}

\item{useOHT}{If \code{TRUE} (default), Optimal Hard Thresholding (OHT) is 
used to estimate the optimal encoding dimension. OHT is only supported for 
the Intron Jaccard Index.}

\item{implementation}{The method that should be used to correct for 
confounders.}

\item{q_param}{Vector specifying which values of q should be tested}

\item{noise_param}{Vector specifying which noise levels should be tested.}

\item{minDeltaPsi}{Minimal delta psi of an intron to be be considered a 
variable intron.}

\item{iterations}{The maximal number of iterations. When the autoencoder has 
not yet converged after these number of iterations, the fit stops anyway.}

\item{setSubset}{The size of the subset of the most variable introns that 
should be used for the hyperparameter optimization.}

\item{injectFreq}{The frequency with which outliers are injected into the 
data.}

\item{BPPARAM}{the BiocParallel parameters for the parallelization}

\item{internalThreads}{The number of threads used internally.}

\item{plot}{If \code{TRUE}, a plot of the singular values (OHT) or the area
under the curve and the model loss for each evaluated parameter
combination (grid-search) will be displayed after the estimation procedure.}

\item{delayed}{If FALSE, count matrices will be loaded into memory (faster 
calculations), otherwise the function works on the delayedMatrix 
representations (more memory efficient). The default value depends on the 
number of samples in the fds-object.}

\item{...}{Additional parameters passed to \code{injectOutliers}.}
}
\value{
FraserDataSet
}
\description{
Finds the optimal encoding dimension by either Optimal Hard Thresholding 
or injecting artificial splicing outlier ratios while maximizing the 
precision-recall curve.
}
\examples{
  # generate data
  fds <- makeSimulatedFraserDataSet(m=15, j=20)
  fds <- calculatePSIValues(fds)
  
  # run OHT
  fds <- estimateBestQ(fds, type="jaccard", useOHT=TRUE)
  
  # run hyperparameter optimization
  fds <- estimateBestQ(fds, type="jaccard", useOHT=FALSE, q_param=c(2, 5))
  
  # get estimated optimal dimension of the latent space
  bestQ(fds, type="jaccard")
  hyperParams(fds, type="jaccard")
  
}
\seealso{
\code{\link{FRASER}}
}
