% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_functions.R
\name{createTestFraserSettings}
\alias{createTestFraserSettings}
\alias{createTestFraserDataSet}
\title{Create a test dataset}
\usage{
createTestFraserSettings(workingDir = "FRASER_output")

createTestFraserDataSet(
  workingDir = "FRASER_output",
  rerun = FALSE,
  metrics = "jaccard"
)
}
\arguments{
\item{workingDir}{Directory where to store HDF5 and RDS files. Defaults to
\code{FRASER_output} in the current working directory.}

\item{rerun}{Defaults to \code{FALSE}. If set to \code{TRUE} it reruns the
full fit of the model.}

\item{metrics}{The splice metrics that should be included in the test fds. 
One or several of 'jaccard', 'psi5', 'psi3' or 'theta'.}
}
\value{
A FraserDataSet object that contains a test case
}
\description{
Create a test case dataset based on the test sample annotation to be 
used in the vignette and to explore the functionality of the 
FRASER package. Dependent on the request only the sample annotation 
or a full fitted model is returned.
}
\examples{
fds <- createTestFraserSettings()
fds

fds <- createTestFraserDataSet()
fds

}
