// #include <testthat.h>
// #include <string>
// #include <vector>
// #include <iostream>
// #include <Rcpp.h>

// #include "../classes/GFFData.h"
// #include "../classes/GeneAnnotationParser.h"
// #include "../classes/types.h"
// #include "../utility/parsing.h"

// #include "test_utilities.h"

// static std::unordered_map<std::string, std::vector<std::string>>
// chr_to_gene = {{"SIRV1", {"SIRV1"}}, {"SIRV2", {"SIRV2"}}, {"SIRV3", {"SIRV3"}}, {"SIRV4", {"SIRV4"}}, {"SIRV5", {"SIRV5"}}, {"SIRV6", {"SIRV6"}},{"SIRV7", {"SIRV7"}}};

// static std::unordered_map<std::string, transcriptvector>
// gene_to_transcript = {{"SIRV1", {"SIRV105", "SIRV101", "SIRV103", "SIRV109", "SIRV108", "SIRV106", "SIRV102", "SIRV107"}}, {"SIRV2", {"SIRV206", "SIRV202", "SIRV205", "SIRV203", "SIRV204", "SIRV201"}}, {"SIRV3", {"SIRV303", "SIRV302", "SIRV309", "SIRV308", "SIRV310", "SIRV307", "SIRV311", "SIRV301", "SIRV304", "SIRV306", "SIRV305"}}, {"SIRV4", {"SIRV410", "SIRV406", "SIRV405", "SIRV408", "SIRV403", "SIRV404", "SIRV409"}}, {"SIRV5", {"SIRV508", "SIRV512", "SIRV511", "SIRV501", "SIRV510", "SIRV506", "SIRV509", "SIRV503", "SIRV505", "SIRV507", "SIRV502", "SIRV504"}}, {"SIRV6", {"SIRV617", "SIRV602", "SIRV615", "SIRV604", "SIRV618", "SIRV611", "SIRV607", "SIRV603", "SIRV614", "SIRV608", "SIRV613", "SIRV610", "SIRV601", "SIRV605", "SIRV609", "SIRV612", "SIRV606", "SIRV616"}}, {"SIRV7", {"SIRV701", "SIRV702", "SIRV708", "SIRV704", "SIRV703", "SIRV706", "SIRV705"}}};

// static std::unordered_map<std::string, std::vector<exon>>
// transcript_to_exon = {
//     {"SIRV101", {{1000, 1484}, {6337, 6473}, {6560, 6813}, {7552, 7814}, {10282, 10366}, {10444, 10786}}},
//     {"SIRV102", {{1006, 1484}, {6337, 6813}, {7552, 7814}, {10282, 10366}}},
//     {"SIRV103", {{1000, 1484}, {6337, 6473}, {6560, 6813}, {7552, 7814}, {10282, 10366}, {10647, 10791}}},
//     {"SIRV105", {{6449, 6473}, {6560, 6813}, {7552, 7814}, {10282, 10366}, {10593, 10640}}},
//     {"SIRV106", {{1000, 1484}, {7552, 7808}, {10553, 10786}}},
//     {"SIRV107", {{10647, 10791}, {10882, 11242}, {11403, 11643}}},
//     {"SIRV108", {{10582, 10791}, {10897, 11187}, {11403, 11606}}},
//     {"SIRV109", {{10711, 10791}, {10882, 11057}, {11434, 11643}}},
//     {"SIRV201", {{1000, 1661}, {1741, 1853}, {1973, 2064}, {2674, 2802}, {2881, 3010}, {3105, 3374}, {3665, 3825}, {3966, 4094}, {4338, 4479}, {4687, 4800}, {5788, 5907}}},
//     {"SIRV202", {{1035, 1661}, {1741, 1853}, {1973, 2064}, {2674, 2802}, {2881, 3010}, {3105, 3325}, {3665, 3825}, {3966, 4094}, {4338, 4479}, {4687, 4800}, {5788, 5911}}},
//     {"SIRV203", {{3665, 3825}, {3966, 4094}, {4338, 4479}, {4687, 4800}, {5751, 5895}}},
//     {"SIRV204", {{3643, 3825}, {3966, 4479}, {4687, 4732}}},
//     {"SIRV205", {{1108, 1631}}},
//     {"SIRV206", {{4033, 4457}}},
//     {"SIRV301", {{1944, 2005}, {4568, 4779}, {6057, 7988}, {8127, 8207}, {8755, 8939}}},
//     {"SIRV302", {{1963, 2005}, {6057, 7822}}},
//     {"SIRV303", {{1963, 2005}, {4568, 4779}, {6057, 7822}}},
//     {"SIRV304", {{1963, 2005}, {4003, 4080}, {4568, 4779}, {6057, 6333}, {7270, 7366}, {7872, 7988}, {8124, 8207}, {8755, 8937}}},
//     {"SIRV305", {{4003, 4080}, {4568, 4779}, {6570, 6718}}},
//     {"SIRV306", {{1944, 2005}, {4003, 4080}, {6057, 8292}}},
//     {"SIRV307", {{1963, 2005}, {4003, 4080}, {4574, 4774}, {6057, 6333}, {8755, 8939}}},
//     {"SIRV308", {{1000, 1167}, {1532, 1764}, {1902, 1982}}},
//     {"SIRV309", {{8797, 8975}, {9189, 9298}, {9434, 9943}}},
//     {"SIRV310", {{8759, 8966}, {9189, 9324}, {9667, 9914}}},
//     {"SIRV311", {{4601, 4762}}},
//     {"SIRV403", {{8322, 8372}, {8629, 8990}, {13672, 13828}, {15019, 15122}}},
//     {"SIRV404", {{8322, 8372}, {8629, 8990}, {13672, 13822}, {14592, 14623}}},
//     {"SIRV405", {{8629, 8990}, {13672, 13937}}},
//     {"SIRV406", {{3637, 4103}, {5007, 5158}}},
//     {"SIRV408", {{8323, 8372}, {8629, 8747}, {8846, 8990}, {13672, 13828}, {15019, 15122}}},
//     {"SIRV409", {{1000, 1346}, {1678, 1885}, {2389, 3403}}},
//     {"SIRV410", {{1455, 1885}, {2251, 2771}}},
//     {"SIRV501", {{1056, 1149}, {1987, 2033}, {2119, 2315}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6658, 6722}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8016}, {8277, 8381}, {8454, 8585}, {10858, 10991}}},
//     {"SIRV502", {{1019, 1149}, {1987, 2033}, {2119, 2156}, {2270, 2488}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6658, 6722}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8016}, {8277, 8381}, {8454, 8585}, {10858, 10989}}},
//     {"SIRV503", {{8201, 8585}, {10858, 10991}, {11133, 11142}}},
//     {"SIRV504", {{11133, 13606}}},
//     {"SIRV505", {{1000, 1149}, {1987, 2033}, {2119, 2156}, {2270, 2315}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8381}, {8454, 8585}, {10858, 10991}}},
//     {"SIRV506", {{1008, 1149}, {1987, 2398}}},
//     {"SIRV507", {{1027, 1149}, {1925, 2033}, {2119, 2156}, {2270, 2315}, {3298, 3404}, {3483, 3598}}},
//     {"SIRV508", {{1008, 1149}, {1987, 2033}, {2119, 2156}, {2270, 2315}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6658, 6722}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8381}, {8454, 8585}, {10858, 10991}}},
//     {"SIRV509", {{8315, 8381}, {8454, 8585}, {10858, 10991}, {11311, 11866}}},
//     {"SIRV510", {{1028, 1149}, {1987, 2033}, {2119, 2156}, {2270, 2315}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8016}, {8277, 8381}, {8454, 8585}, {10858, 10991}, {11133, 11867}}},
//     {"SIRV511", {{1008, 1143}, {1987, 2398}}},
//     {"SIRV512", {{2177, 2406}}},
//     {"SIRV601", {{1000, 1186}, {1468, 1534}, {1640, 1735}, {2470, 2620}, {2740, 2828}, {3106, 3164}, {10724, 10818}, {11031, 11108}, {11205, 11826}}},
//     {"SIRV602", {{1124, 1186}, {1468, 1534}, {1640, 1735}, {2780, 2828}, {3106, 3164}, {10724, 10818}, {11031, 11108}, {11205, 11279}}},
//     {"SIRV603", {{8999, 10968}}},
//     {"SIRV604", {{1087, 1186}, {1468, 1534}, {1640, 1735}, {1845, 2026}, {2470, 2620}, {2740, 2828}, {3106, 3164}, {10724, 10818}, {11034, 11108}, {11205, 11837}}},
//     {"SIRV605", {{1130, 1186}, {1468, 1534}, {1640, 1735}, {1845, 2026}, {2470, 2620}, {2740, 2828}, {3106, 3164}, {10724, 10818}, {11031, 11331}}},
//     {"SIRV606", {{2285, 2620}, {2740, 2828}, {3106, 3164}, {10724, 10788}}},
//     {"SIRV607", {{1130, 1186}, {1468, 1735}, {1845, 2026}, {2470, 2540}}},
//     {"SIRV608", {{3023, 3164}, {10724, 10818}, {11031, 11108}, {11205, 11270}}},
//     {"SIRV609", {{1137, 1186}, {1468, 1534}, {1640, 1735}, {1845, 2120}}},
//     {"SIRV610", {{2472, 2620}, {2740, 2828}, {3106, 3164}, {10724, 11108}, {11205, 11690}}},
//     {"SIRV611", {{1303, 1381}, {1468, 1534}, {1640, 1950}}},
//     {"SIRV612", {{1087, 1186}, {1468, 1534}, {1640, 1735}, {1845, 2026}, {2470, 2620}, {2740, 2828}, {3106, 3164}, {10724, 10818}, {11031, 11108}, {11205, 11825}}},
//     {"SIRV613", {{3105, 3164}, {7104, 7448}, {7805, 7923}, {10724, 10818}, {11031, 11108}, {11205, 11824}}},
//     {"SIRV614", {{2516, 2620}, {2740, 2828}, {3106, 3164}, {7805, 7923}, {10724, 10815}}},
//     {"SIRV615", {{10237, 10818}, {11031, 11108}, {11205, 11330}}},
//     {"SIRV616", {{2285, 2620}, {2740, 2814}, {3106, 3164}, {10724, 10788}}},
//     {"SIRV617", {{1544, 1820}}},
//     {"SIRV618", {{2358, 2547}}},
//     {"SIRV701", {{1003, 2675}, {2993, 3111}, {43028, 43077}, {114680, 114988}, {147608, 147923}}},
//     {"SIRV702", {{1000, 2675}, {2993, 3111}, {4095, 4179}, {4725, 4810}, {43028, 43077}, {114680, 114916}}},
//     {"SIRV703", {{1000, 2675}, {2993, 3111}, {3809, 3896}, {114680, 114988}, {147608, 147918}}},
//     {"SIRV704", {{55849, 56097}, {78841, 78963}, {114680, 114738}}},
//     {"SIRV705", {{1005, 2675}, {2993, 3111}, {43028, 43077}, {114680, 114988}, {147608, 147925}}},
//     {"SIRV706", {{56031, 56097}, {70883, 70987}, {78841, 78963}, {114680, 114988}, {147608, 147957}}},
//     {"SIRV708", {{56037, 56097}, {70883, 70987}, {78841, 78908}, {78928, 78963}, {114686, 114960}, {147608, 147957}}}
// };

// context("File Parsing & String Parsing") {
//     test_that("GTF File is correctly parsed") {
//         std::string anno = get_extdata("SIRV_anno.gtf");

//         GFFData data = parse_gff_file(anno);

//         expect_true(data.chr_to_gene.size() == 7);
//         expect_true(data.gene_to_transcript.size() == 7);
//         expect_true(data.transcript_dict.size() == 69);
//         expect_true(data.transcript_to_exon.size() == 69);

//         expect_true(compare_map(chr_to_gene, data.chr_to_gene));

//         expect_true(compare_map(gene_to_transcript, data.gene_to_transcript));

//         expect_true(compare_map(transcript_to_exon, data.transcript_to_exon));
//     }

//     test_that("String parsing can split a string, and not fail") {
//         std::vector<std::string> s = {
//             "file.ext", "", "notafile" 
//         };
//         auto vec1 = splitStringToVector(s[0], '.');
//         expect_true((vec1.size() == 2 && vec1[0] == "file"));
//         auto vec2 = splitStringToVector(s[1], '.');
//         expect_true(vec2.size() == 0);
//         auto vec3 = splitStringToVector(s[2], '.');
//         expect_true(vec3.size() == 0);
//         auto vec4 = splitStringToVector(s[0], '$');
//         expect_true(vec4.size() == 0);
//     }

//     test_that("Strings can be stripped correctly, L R and both") {
//         std::vector<std::string> s = {
//             "  \tfirst",
//             "second  \t  ",
//             "  third  \t"
//         };

//         expect_true(leftStrip(s[0]) == "first");
//         expect_true(rightStrip(s[1]) == "second");
//         expect_true(strip(s[2]) == "third");
//     }
// }