% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_mutations.R
\name{sc_genotype}
\alias{sc_genotype}
\title{Genotype a single-cell mutation}
\usage{
sc_genotype(
  snps_tb,
  ref,
  alt,
  seqname,
  pos,
  alt_min_count = 2,
  alt_min_pct = 0.1,
  ref_min_count = 1,
  ref_min_pct = 1
)
}
\arguments{
\item{snps_tb}{tibble: the SNPs table, output from \code{sc_mutations}.}

\item{ref}{character(1): the reference allele.}

\item{alt}{character(1): the alternative allele.}

\item{seqname}{character(1): the chromosome name of the position.}

\item{pos}{integer(1): the position of the mutation, 1-based.}

\item{alt_min_count}{integer(1): minimum UMI count of the alternative allele to call it "alt".}

\item{alt_min_pct}{numeric(1): minimum percentage of the alternative allele to call it "alt".}

\item{ref_min_count}{integer(1): minimum UMI count of the reference allele to call it "ref".}

\item{ref_min_pct}{numeric(1): minimum percentage of the reference allele to call it "ref".}
}
\value{
A tibble with columns: barcode, allele_count_ref, pct_ref, allele_count_alt, pct_alt, genotype.
}
\description{
A simplistic function to genotype a single-cell mutation at a given position.
It filters the SNPs table for the given reference and alternative alleles, and
determines the genotype based on the allele counts and percentages.
}
\examples{
# get the SNPs table from sc_mutations
example(sc_mutations)
genotype_tb <- snps_tb |>
  sc_genotype(
    ref = "G", alt = "A", seqname = "chr14", pos = 1260,
    alt_min_count = 2, alt_min_pct = 0.1,
    ref_min_count = 1, ref_min_pct = 1
  )
dplyr::count(genotype_tb, genotype)
head(genotype_tb)
}
