% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_annotate_plots.R
\name{plot_isoforms}
\alias{plot_isoforms}
\title{Plot isoforms}
\usage{
plot_isoforms(
  sce,
  gene_id,
  transcript_ids,
  n = 4,
  format = "plot_grid",
  colors
)
}
\arguments{
\item{sce}{The \code{SingleCellExperiment} object containing transcript counts, 
\code{rowRanges} and \code{rowData} with \code{gene_id} and \code{transcript_id} columns.}

\item{gene_id}{The gene symbol of interest, ignored if \code{transcript_ids} is provided.}

\item{transcript_ids}{The transcript ids to plot.}

\item{n}{The number of top isoforms to plot from the gene. Ignored if \code{transcript_ids} is provided.}

\item{format}{The format of the output, either "plot_grid" or "list".}

\item{colors}{A character vector of colors to use for the isoforms.
If not provided, gray will be used. for all isoforms.}
}
\value{
When \code{format = "list"}, a list of \code{ggplot} objects is returned. 
Otherwise, a grid of the plots is returned.
}
\description{
Plot isoforms, either from a gene or a list of transcript ids.
}
\details{
This function takes a \code{SingleCellExperiment} object and plots the top isoforms of a gene,
or a list of specified transcript ids. Either as a list of plots or together in a grid.
This function wraps the \code{ggbio::geom_alignment} function to plot the isoforms, and orders
the isoforms by expression levels (when specifying a gene) or by the order of the transcript_ids.
}
\examples{
data(scmixology_lib10_transcripts)
plot_isoforms(scmixology_lib10_transcripts, gene_id = "ENSG00000108107")

}
