% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-SingleCellPipeline.R
\name{plot_demultiplex}
\alias{plot_demultiplex}
\alias{plot_demultiplex,FLAMES.SingleCellPipeline-method}
\title{Plot Cell Barcode demultiplex statistics}
\usage{
plot_demultiplex(pipeline)

\S4method{plot_demultiplex}{FLAMES.SingleCellPipeline}(pipeline)
}
\arguments{
\item{pipeline}{A \code{FLAMES.SingleCellPipeline} object}
}
\value{
a list of ggplot objects:
\itemize{
\item reads_count_plot: stacked barplot of: demultiplexed reads
\item knee_plot: knee plot of UMI counts before TSO trimming
\item flank_editdistance_plot: flanking sequence (adaptor) edit-distance plot
\item barcode_editdistance_plot: barcode edit-distance plot
\item cutadapt_plot: if TSO trimming is performed, number of reads kept by cutadapt
}
}
\description{
produce a barplot of cell barcode demultiplex statistics
}
\examples{
pipeline <- example_pipeline("MultiSampleSCPipeline") |>
  run_step("barcode_demultiplex")
plot_demultiplex(pipeline)
}
