% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_functions.R
\name{create_config}
\alias{create_config}
\title{Create Configuration File From Arguments}
\usage{
create_config(outdir, type = "sc_3end", ...)
}
\arguments{
\item{outdir}{the destination directory for the configuration file}

\item{type}{use an example config, available values:
\describe{
 \item{"sc_3end"}{ - config for 10x 3' end ONT reads}
 \item{"SIRV"}{ - config for the SIRV example reads}
}}

\item{...}{Configuration parameters (using dot for nested parameters)
\describe{
 \item{seed}{ - Integer. Seed for minimap2.}
 \item{threads}{ - Number of threads to use.}
 \item{do_barcode_demultiplex}{ - Boolean. Specifies whether to run the
 barcode demultiplexing step.}
 \item{do_genome_alignment}{ - Boolean. Specifies whether to run the genome
 alignment step. \code{TRUE} is recommended}
 \item{do_gene_quantification}{ - Boolean. Specifies whether to run gene
 quantification using the genome alignment results. \code{TRUE} is
 recommended}
 \item{do_isoform_identification}{ - Boolean. Specifies whether to run the
 isoform identification step. \code{TRUE} is recommended}
 \item{bambu_isoform_identification}{ - Boolean. Whether to use Bambu for
 isoform identification.}
 \item{multithread_isoform_identification}{ - Boolean. Whether to use FLAMES'
 new multithreaded Cpp implementation for isoform identification.}
 \item{do_read_realignment}{ - Boolean. Specifies whether to run the read
 realignment step. \code{TRUE} is recommended}
 \item{do_transcript_quantification}{ - Boolean. Specifies whether to run the
 transcript quantification step. \code{TRUE} is recommended}
 \item{barcode_parameters.max_bc_editdistance}{ - Maximum edit distance for
 barcode matching}
 \item{barcode_parameters.pattern.primer}{ - Primer sequence pattern}
 \item{isoform_parameters.max_dist}{ - Maximum distance allowed when merging
 splicing sites}
 \item{...}{ - Other nested parameters, using dot to indicate nested section}
}}
}
\value{
file path to the config file created
}
\description{
Create Configuration File From Arguments
}
\details{
Create a list object containing the arguments supplied in a format
usable for the FLAMES pipeline, and writes the object to a JSON file, which
is located with the prefix 'config_' in the supplied \code{outdir}. Default
values from \code{extdata/config_sclr_nanopore_3end.json} will be used for
unprovided parameters.

Parameters can be specified using dot to indicate nested sections, e.g.,
\code{barcode_parameters.max_bc_editdistance = 3} or
\code{barcode_parameters.pattern.primer = "ATCG"}. Alternatively, you can
open the created config file and edit it manually.
}
\examples{
# create the default configuration file
outdir <- tempdir()
config <- create_config(outdir)

# create config with custom parameters including nested ones
config <- create_config(outdir,
  threads = 16,
  barcode_parameters.max_bc_editdistance = 3,
  barcode_parameters.pattern.primer = "ATCGATCG",
  isoform_parameters.min_sup_cnt = 10,
  # use the coverage model in oarfish
  # via supplying additional CLI arguments
  additional_arguments.oarfish = c("--model-coverage")
)

}
