% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-.R
\name{getExcluded}
\alias{getExcluded}
\title{Get excluded compounds}
\usage{
getExcluded(object)
}
\arguments{
\item{object}{FELLA.USER object}
}
\value{
Vector of the excluded compounds
}
\description{
Extractor function for the compounds in the input 
that were not mapped to the KEGG graph
}
\examples{
data(FELLA.sample)
data(input.sample)

## No excluded compounds
obj <- defineCompounds(
compounds = input.sample, 
data = FELLA.sample)
getExcluded(obj)

## One compound does not map
## The user gets a warning as well
obj <- defineCompounds(
compounds = c(input.sample, "intruder"), 
data = FELLA.sample)
getExcluded(obj)
}
