% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllArguments.R
\name{checkArguments}
\alias{checkArguments}
\title{Internal function to check arguments and give personalised errors}
\usage{
checkArguments(databaseDir = "myDatabase", internalDir = TRUE,
    method = "diffusion", methods = "diffusion", approx = "normality",
    loadMatrix = NULL, threshold = 0.05, plimit = 15, nlimit = 250,
    niter = 1000, t.df = 10, dampingFactor = 0.85, layout = FALSE,
    thresholdConnectedComponent = 0.05, GOterm = NULL,
    GONamesAsLabels = TRUE, LabelLengthAtPlot = 22,
    object = new("FELLA.USER"), data = new("FELLA.DATA"), ...)
}
\arguments{
\item{databaseDir}{Path for the KEGG RData files}

\item{internalDir}{Logical, is the directory located 
in the package directory?}

\item{method}{Character, exactly one of: 
\code{"hypergeom"}, \code{"diffusion"}, \code{"pagerank"}}

\item{methods}{Character vector, containing some of: 
\code{"hypergeom"}, \code{"diffusion"}, \code{"pagerank"}}

\item{approx}{Character: "simulation" for Monte Carlo, "normality", 
"gamma" or "t" for parametric approaches}

\item{loadMatrix}{Character vector to choose if 
heavy matrices should be loaded. 
Can contain: \code{"diffusion"}, \code{"pagerank"}}

\item{threshold}{Numeric value between 0 and 1. 
\code{p.score} threshold applied when filtering KEGG nodes. 
Lower thresholds are more stringent.}

\item{plimit}{Pathway limit, must be a numeric value between 1 and 50. 
Limits the amount of pathways in \code{method = "hypergeom"}}

\item{nlimit}{Node limit, must be a numeric value between 1 and 1000. 
Limits the order of the solution sub-graph when 
in \code{method = "diffusion"} and \code{method = "pagerank"}}

\item{niter}{Number of iterations (permutations) 
for Monte Carlo ("simulation"), 
must be a numeric value between 1e2 and 1e5}

\item{t.df}{Numeric value; number of degrees of freedom 
of the t distribution 
if the approximation \code{approx = "t"} is used}

\item{dampingFactor}{Numeric value between 0 and 1 (none inclusive), 
damping factor \code{d} for 
PageRank (\code{\link[igraph:page_rank]{page.rank}})}

\item{layout}{Logical, should the plot be returned as a layout?}

\item{thresholdConnectedComponent}{Numeric value between 0 and 1. 
Connected components that are below the threshold are kept, 
while the ones exceeding it (because they are too small) are discarded.}

\item{GOterm}{Character, GO entry to draw 
semantic similarity in the solution graph. 
If \code{NULL}, the GO labels will be appended without similarities.}

\item{GONamesAsLabels}{Logical, should GO names 
be displayed as labels instead of GO identifiers?}

\item{LabelLengthAtPlot}{Numeric value between 10 and 50. 
Maximum length that a label can reach when plotting the graph. 
The remaining characters will be truncated using "..."}

\item{object}{FELLA.USER object}

\item{data}{FELLA.DATA object}

\item{...}{ignored arguments}
}
\value{
A list with values. Currently only a 
logical value named \code{valid} 
if the process runs smoothly. If the checking fails, 
it also returns an 
object called \code{ans}, which depends on 
the situation (can be the original object, 
\code{NULL}, et cetera).
}
\description{
This function checks if the arguments are of the desired type, length 
and range. If it fails, it gives an error explaining why the argument 
is invalid.
}
\examples{
## This function is internal
arg1 <- FELLA:::checkArguments(method = "hello")
arg1$valid
arg2 <- FELLA:::checkArguments(method = "diffusion")
arg2$valid

}
\keyword{internal}
