% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Popular_Clust_Methods.R
\name{TSCAN_Clust}
\alias{TSCAN_Clust}
\title{TSCAN Clustering}
\usage{
TSCAN_Clust(Y, k, minexpr_percent = 0.5, cvcutoff = 1, input_markers = NULL)
}
\arguments{
\item{Y}{A expression matrix. It is recommended to use the raw count matrix.}

\item{k}{The number of clusters. If it is not provided, k is estimated by the default method in SC3.}

\item{minexpr_percent}{minimum expression threshold (default = 0.5).}

\item{cvcutoff}{the cv cutoff to filter the genes (default = 1).}

\item{input_markers}{A character vector including the featured genes. If they are not presented, SC3 will take care of this.}
}
\value{
the clustering labels and the featured genes.
}
\description{
TSCAN Clustering
}
\examples{
 data(Yan)
 k = length(unique(trueclass))
 # TSCAN_res = TSCAN_Clust(Y, k=k)
}
