% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FEAST.R
\name{FEAST_fast}
\alias{FEAST_fast}
\title{FEAST main function (fast version)}
\usage{
FEAST_fast(Y, k = 2, num_pcs = 10, split = FALSE, batch_size = 1000, nProc = 1)
}
\arguments{
\item{Y}{A expression matrix. Raw count matrix or normalized matrix.}

\item{k}{The number of input clusters (best guess).}

\item{num_pcs}{The number of top pcs that will be investigated through the consensus clustering.}

\item{split}{boolean. If T, using subsampling to calculate the gene-level significance.}

\item{batch_size}{when split is true, need to claim the batch size for spliting the cells.}

\item{nProc}{number of cores for BiocParallel enviroment.}
}
\value{
the rankings of the gene-significance.
}
\description{
FEAST main function (fast version)
}
\examples{
data(Yan)
k = length(unique(trueclass))
res = FEAST_fast(Y, k=k)
}
