\name{createAB}
\alias{createAB}

\title{
ExiMiR function for creating an AffyBatch object from other object types (RGList, EListRaw, MAList or list)
}

\description{
This function creates an \code{AffyBatch} object from a \code{limma} object (\code{RGList}, \code{EListRaw}, \code{MAList}) or from any appropriate \code{list} object.
}
\usage{
createAB(object,
         verbose=TRUE,
         ref.channel="R",
         genes.block=NULL,
         genes.row=NULL,
         genes.col=NULL,
         genes.id=NULL,
         genes.name=NULL,
         galname=NULL,
         env.overwrite=TRUE,
         ...)
}

\arguments{
\item{object}{
	An appropriate \code{EListRaw}, \code{RGList}, \code{MAList} or \code{list} object.
}
\item{verbose}{
	Logical. The default value is \code{TRUE}. The details of the function execution are displayed on the console.
}
\item{genes.block}{
	Optional character vector in case the platform is neither ImaGene, Exiqon nor Agilent. The name of the column
	in the \code{object$genes} data frame that contains the block or field values.
}
\item{genes.row}{
	Optional character vector in case the platform is neither ImaGene, Exiqon nor Agilent. The name of the column
	in the \code{object$genes} data frame that contains the row values.
}
\item{genes.col}{
	Optional character vector in case the platform is neither ImaGene, Exiqon nor Agilent. The name of the column
in the \code{object$genes} data frame that contains the column values.
}
\item{genes.id}{
	Optional character vector in case the platform is neither ImaGene, Exiqon nor Agilent. The name of the column
in the \code{object$genes} data frame that contains the gene IDs.
}
\item{genes.name}{
	Optional character vector in case the platform is neither ImaGene, Exiqon nor Agilent. The name of the column
	in the \code{object$genes} data frame that contains gene names.
}
\item{ref.channel}{
	Character vector. The value of the reference channel for two-color arrays ('R' or 'G') 
}
\item{galname}{
	Character vector. The default value is \code{NULL}. In this case the GAL annotation
	environment used by \code{createAB} for generating the resulting \code{AffyBatch}
	object is lost. Assigning \code{galname} a non-empty value allows to control this GAL
	environment, which is useful in two specific situations. First, it gives a handle to this
	GAL annotation environment for later use. Second, if an adequate GAL annotation environment already
	exists in the memory (e.g. after having been generated by \code{createAB} or by
	\code{make.gal.env}), \code{galname} allows to force \code{createAB} to use it for
	generating the resulting \code{AffyBatch} object.
}
\item{env.overwrite}{
	Logical. The default value is \code{TRUE}. If a GAL annotation environment with the
	same name already exists in the memory, it will be overwritten. This may be useful
	when the piece of code containing \code{createAB} is run several times.
}
\item{...}{
	Any additional argument that can be given to the \code{AffyBatch} constructor, as specified
	in the documentation of the \code{AffyBatch} object provided in the \code{affy} package.
}
}

\details{
See accompanying vignette.
}

\value{
An \code{AffyBatch} object containing the raw expression data.
}

\author{
Sylvain Gubian, Alain Sewer, PMP SA
}


\seealso{
\code{ReadExi},
\code{make.gal.env}.
}
