% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResulTable.R
\name{ResulTable}
\alias{ResulTable}
\title{ResulTable}
\usage{
ResulTable(EP_Result,coef = 1,number = Inf)
}
\arguments{
\item{EP_Result}{The output of the function EventPointer_Bootstraps}

\item{coef}{Number specifying which coefficient or contrast of the model is of interest.}

\item{number}{Maximum number of events to list}
}
\value{
A dataframe with a row for the number of top events and the following columns:

deltaPSI: the difference of PSI between conditions

pvalue: raw p-value

lfdr: local false discovery rate

qvalue: adjusted p-value or q-value
}
\description{
Extract a table of the top-ranked events from the output of EventPointer_Bootstraps.
}
\examples{

     data(PSIss)
     PSI <- PSIss$PSI
     
     Dmatrix <- cbind(1,rep(c(0,1),each=2))
     Cmatrix <- matrix(c(0,1),nrow=2)
     
     Fit <- EventPointer_Bootstraps(PSI = PSI,
                                    Design = Dmatrix,
                                    Contrast = Cmatrix,
                                    cores = 1,
                                    ram = 1,
                                    nBootstraps = 10,
                                    UsePseudoAligBootstrap = TRUE)
     
     ResulTable(EP_Result = Fit,coef = 1,number = 5)

}
