% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPSI_FromTranRef.R
\name{GetPSI_FromTranRef}
\alias{GetPSI_FromTranRef}
\title{GetPSI_FromTranRef}
\usage{
GetPSI_FromTranRef(
  Samples,
  PathsxTranscript,
  Bootstrap = FALSE,
  Filter = TRUE,
  Qn = 0.25
)
}
\arguments{
\item{Samples}{matrix or list containing the expression of the samples.}

\item{PathsxTranscript}{the output of EventDetection_transcriptome.}

\item{Bootstrap}{Boolean variable to indicate if bootstrap data from pseudo-alignment is used.}

\item{Filter}{Boolean variable to indicate if an expression filter is applied. Default TRUE.}

\item{Qn}{Quartile used to filter the events (Bounded between 0-1, Qn would be 0.25 by default).}
}
\value{
The output is a list containing two elements: a matrix with the
values of PSI  and a list containing as many matrices as number of events.
In each matrix is stored the expression of the different paths of an event along the samples.
}
\description{
Get the values of PSI. A filer expression is applied if
the user select the option of filter.
}
\examples{
     data(EventXtrans)
     
     PathSamples <- system.file("extdata",package="EventPointer")
     PathSamples <- paste0(PathSamples,"/output")
     PathSamples <- dir(PathSamples,full.names = TRUE)
     
     data_exp <- getbootstrapdata(PathSamples = PathSamples,type = "kallisto")
     
     #same annotation
     rownames(data_exp[[1]]) <- gsub("\\\\|.*","",rownames(data_exp[[1]]))
     
     #Obtain values of PSI
     PSI_List <- GetPSI_FromTranRef(PathsxTranscript = EventXtrans,Samples = data_exp,Bootstrap = TRUE, Filter = FALSE)
     PSI <- PSI_List$PSI
     Expression_List <- PSI_List$ExpEvs

}
