% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventDetection_ST.R
\name{EventsDetection_ST}
\alias{EventsDetection_ST}
\title{Detection of alternative splicing events from transcriptome quantification}
\usage{
EventsDetection_ST(
  PathSamplesAbundance = NULL,
  typeAbundance = "kallisto",
  PathTranscriptomeGTF = NULL,
  EventsTranscriptome = NULL,
  Bootstrap = TRUE,
  Filter = FALSE,
  Qn = 0.25,
  cores = 1,
  PathEventsGTFResults = "."
)
}
\arguments{
\item{PathSamplesAbundance}{Path to quantification data of gene isoforms
obtained from the corresponding pseudoaligner.}

\item{typeAbundance}{Type of abundance files provided for the PSI analysis.
The options are "salmon" or "kallisto".}

\item{PathTranscriptomeGTF}{Path to the reference transcriptome GTF file.}

\item{EventsTranscriptome}{Optional. Pre-computed events from transcriptome.
If NULL, events will be detected from the GTF file.}

\item{Bootstrap}{Logical. If TRUE, bootstrap replicates are used for PSI
calculation. Default is TRUE.}

\item{Filter}{Logical. If TRUE, filters events based on expression levels.
Default is FALSE.}

\item{Qn}{Numeric. Quantile threshold for filtering (between 0 and 1).
Default is 0.25.}

\item{cores}{Integer. Number of cores to use for parallel processing.
Default is 1.}

\item{PathEventsGTFResults}{Path where results will be saved. Default is
current directory ("."). The following files are obtained:
   EventsTranscriptome.RData: Detected events data in RData format.
   PSI_ST.RData: $\Psi$ per event and sample in RData format.}
}
\value{
A list containing PSI (Percent Spliced In) values and associated
  statistics for detected splicing events across samples.
}
\description{
Identifies alternative splicing events from transcript-level abundance data
(Kallisto, Salmon, RSEM) using a reference transcriptome GTF file.
}
\examples{
\dontrun{
PathFiles <- system.file("extdata", package = "EventPointer")
PathTranscriptomeGTF <- paste(PathFiles,"/gencode.v24.ann_2genes.gtf",sep = "")
PathSamplesAbundance <- paste0(PathFiles, "/output")
PathSamplesAbundance <- dir(PathSamplesAbundance, full.names = TRUE)
Pathtxt <- tempdir()

EventsPSI <- EventsDetection_ST(
  PathSamplesAbundance,
  typeAbundance = "kallisto",
  PathTranscriptomeGTF = PathTranscriptomeGTF,
  EventsTranscriptome = NULL,
  Bootstrap = TRUE,
  Filter = FALSE,
  Qn = 0.25,
  cores = 1,
  PathEventsGTFResults = Pathtxt
)
}
}
