% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventPointer_RNASeq_TranRef_IGV.R
\name{EventPointer_RNASeq_TranRef_IGV}
\alias{EventPointer_RNASeq_TranRef_IGV}
\title{EventPointer RNASeq from reference transcriptome IGV Visualization}
\usage{
EventPointer_RNASeq_TranRef_IGV(SG_List, pathtoeventstable, PathGTF)
}
\arguments{
\item{SG_List}{List with the Splicing Graph information of the events. This list is created by EventDetection_transcriptome function.}

\item{pathtoeventstable}{Complete path to the table returned by EventDetection_transcriptome that contains the information of each event,
or table with specific events that the user want to load into IGV to visualize.}

\item{PathGTF}{Directory where to write the GTF files.}
}
\value{
The function displays a progress bar to show the user the progress of the function. Once the progress bar reaches 100%, one .gtf
file is written to the specified directory in PathGTF. The created file is named 'paths_RNASeq.gtf'.
}
\description{
Generates of files to be loaded in IGV for visualization and interpretation of events detected
from a reference transcriptome (see EventDetection_transcriptome).
}
\examples{

  ###### example using all the events found in a reference transcriptome
  data("EventXtrans")
  SG_List <- EventXtrans$SG_List
  PathEventsTxt<-system.file('extdata',package='EventPointer')
  PathEventsTxt <- paste0(PathEventsTxt,"/EventsFound_Gencode24_2genes.txt")
  PathGTF <- tempdir()
  
  EventPointer_RNASeq_TranRef_IGV(SG_List = SG_List,pathtoeventstable = PathEventsTxt,PathGTF = PathGTF)
  
  
     
}
