% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventPointer_IGV.R
\name{EventPointer_IGV}
\alias{EventPointer_IGV}
\title{EventPointer IGV Visualization}
\usage{
EventPointer_IGV(
  Events,
  input,
  inputFile = NULL,
  PSR,
  Junc,
  PathGTF,
  EventsFile,
  microarray = NULL
)
}
\arguments{
\item{Events}{Data.frame generated by EventPointer with the events to be included
in the GTF file.}

\item{input}{Reference transcriprome. Must be one of: 'Ensembl', 'UCSC' , 'AffyGTF'
or 'CustomGTF'.}

\item{inputFile}{If input is 'AffyGTF' or 'CustomGTF', inputFile should point to the
GTF file to be used.}

\item{PSR}{Path to the Exon probes txt file.}

\item{Junc}{Path to the Junction probes txt file.}

\item{PathGTF}{Directory where to write the GTF files.}

\item{EventsFile}{Path to EventsFound.txt file generated with CDFfromGTF function.}

\item{microarray}{Microarray used to create the CDF file. Must be one of: HTA-2_0,
ClariomD, RTA or MTA.}
}
\value{
The function displays a progress bar to show the user the progress of the function.
Once the progress bar reaches 100%, two .gtf files are written to the specified directory
in PathGTF. 
The created files are: 
1) paths.gtf: GTF file representing the alternative splicing
events.
2) probes.gtf: GTF file representing the probes
that measure each event and each path.
}
\description{
Generates of files to be loaded in IGV for visualization and interpretation of events
}
\examples{

\dontrun{
   PathFiles<-system.file('extdata',package='EventPointer')
   DONSON_GTF<-paste(PathFiles,'/DONSON.gtf',sep='')
   PSRProbes<-paste(PathFiles,'/PSR_Probes.txt',sep='')
   JunctionProbes<-paste(PathFiles,'/Junction_Probes.txt',sep='')
   Directory<-tempdir()

   data(ArraysData)

   Dmatrix<-matrix(c(1,1,1,1,0,0,1,1),nrow=4,ncol=2,byrow=FALSE)
   Cmatrix<-t(t(c(0,1)))
   EventsFound<-paste(system.file('extdata',package='EventPointer'),'/EventsFound.txt',sep='')

   Events<-EventPointer(Design=Dmatrix,
                      Contrast=Cmatrix,
                      ExFit=ArraysData,
                      Eventstxt=EventsFound,
                      Filter=TRUE,
                      Qn=0.25,
                      Statistic='LogFC',
                      PSI=TRUE)

 EventPointer_IGV(Events=Events[1,,drop=FALSE],
                  input='AffyGTF',
                  inputFile=DONSON_GTF,
                  PSR=PSRProbes,
                  Junc=JunctionProbes,
                  PathGTF=Directory,
                 EventsFile= EventsFound,
                 microarray='HTA-2_0')
                 
}

}
