% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventPointerStats_ST.R
\name{EventPointerStats_ST}
\alias{EventPointerStats_ST}
\title{Statistical analysis of alternative splicing events from transcript quantification}
\usage{
EventPointerStats_ST(
  PSI,
  Design,
  Contrast,
  BootstrapStats = TRUE,
  nbootstraps = 10000,
  UsePseudoAligBootstrap = TRUE,
  Threshold = 0,
  cores = 1,
  ram = 4,
  pathResult = "./"
)
}
\arguments{
\item{PSI}{PSI_ST.RData variable resulting from \code{\link{EventsDetection_ST}}.
Contains PSI values and bootstrap information for each event.}

\item{Design}{A matrix defining the linear model. Each row corresponds to a
sample, and each column corresponds to a coefficient (such as the baseline
and treatment effects).}

\item{Contrast}{A numeric matrix with contrasts to be tested. Rows correspond
to coefficients in the design matrix, and columns correspond to contrasts.}

\item{BootstrapStats}{Logical. If TRUE, bootstrap-based statistics are computed.
Default is TRUE.}

\item{nbootstraps}{Integer. Number of bootstrap iterations to use for statistical
testing. Higher numbers increase computational time but improve statistical
power. Default is 10000.}

\item{UsePseudoAligBootstrap}{Logical. If TRUE (default), uses bootstrap data
from pseudoalignment (Kallisto/Salmon) for statistical inference.}

\item{Threshold}{Numeric. Threshold value for computing p-values. Default is 0.}

\item{cores}{Integer. Number of cores to use for parallel processing. Default is 1.}

\item{ram}{Numeric. Amount of RAM (in GB) to use for computations. Default is 4.}

\item{pathResult}{Path where results will be saved. A subdirectory
"EventPointerStatsSTResult" will be created. Default is current directory ("./").}
}
\value{
Creates result files in the specified path containing statistical
  analysis results, including p-values and effect sizes for each contrast.
  Files are saved in CSV format in the "bootstrapResult" subdirectory.
}
\description{
Performs statistical testing on PSI values from transcript-level quantification
to identify differential splicing events between conditions. Uses bootstrap
resampling for robust statistical inference.
}
\examples{
\dontrun{
data(PSI_boots)

Design <- cbind(1, rep(c(0, 1), each = 2))
Contrast <- matrix(c(0, 1), nrow = 2)

pathResult <- tempdir()

EventPointerStats_ST(
  PSI,
  Design,
  Contrast,
  BootstrapStats = TRUE,
  nbootstraps = 10000,
  UsePseudoAligBootstrap = TRUE,
  Threshold = 0,
  cores = 1,
  ram = 4,
  pathResult = pathResult
)
}
}
