% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventPointerStats_BAM.R
\name{EventPointerStats_BAM}
\alias{EventPointerStats_BAM}
\title{Statistical analysis of alternative splicing events from BAM files}
\usage{
EventPointerStats_BAM(
  PSI_boots,
  Design,
  Contrast,
  Threshold = 0,
  nbootstraps = 1000,
  cores = 1,
  ram = 0.1,
  pathResult = "./"
)
}
\arguments{
\item{PSI_boots}{PSI_boots.RData obtained from \code{\link{EventsDetection_BAM}}
function. Contains PSI values and bootstrap information for each event.}

\item{Design}{A matrix defining the linear model. Each row corresponds to a
sample, and each column corresponds to a coefficient (such as the baseline
and treatment effects).}

\item{Contrast}{A numeric matrix with contrasts to be tested. Rows correspond
to coefficients in the design matrix, and columns correspond to contrasts.}

\item{Threshold}{Numeric. Threshold value for computing p-values. Default is 0.}

\item{nbootstraps}{Integer. Number of bootstrap iterations to use for statistical
testing. Higher numbers increase computational time but improve statistical
power. Default is 1000.}

\item{cores}{Integer. Number of cores to use for parallel processing. Default is 1.}

\item{ram}{Numeric. Amount of RAM (in GB) to use for computations. Default is 0.1.}

\item{pathResult}{Path where results will be saved. A subdirectory
"EventPointerStatsResult" will be created containing a table with the results
of the differential $\Psi$ analysis for each contrast. The table presents
the $\Delta \Psi$ associated with each event and its corresponding significance
parameters. Note that a separate table will be generated for each contrast
specified in the contrast matrix. Default is current directory ("./").}
}
\value{
Creates result files in the specified path containing statistical
  analysis results, including p-values and effect sizes for each contrast.
  Files are saved in CSV format in the "bootstrapResult" subdirectory.
}
\description{
Performs statistical testing on PSI values derived from BAM files to identify
differential splicing events between conditions. Uses bootstrap resampling
for robust statistical inference.
}
\examples{
\dontrun{
data(PSI_boots)

Design <- cbind(rep(1, 9), rep(c(1, 0, 0), 3), rep(c(0, 1, 0), 3))
Contrast <- cbind(c(0, 1, 0), c(0, 0, 1))

PathSGResult <- tempdir()

EventPointerStats_BAM(
  PSI_boots,
  Design,
  Contrast,
  Threshold = 0,
  nbootstraps = 1000,
  cores = 1,
  ram = 0.1,
  pathResult = PathSGResult
)
}
}
