% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwrE_to_EpipwR.R
\name{pwrE_to_EpipwR}
\alias{pwrE_to_EpipwR}
\title{Using pwrEWAS effect-size distributions in EpipwR}
\usage{
pwrE_to_EpipwR(maximal_delta, det_limit, quantile = 0.9999)
}
\arguments{
\item{maximal_delta}{The desired 99.99th percentile (unless quantile is
specified) of the effect size
distribution. Must be between 0 and 1.}

\item{det_limit}{The minimum effect size to be used in a power calculation.}

\item{quantile}{The quantile that maximal_delta represents. Note that
pwrEWAS uses \code{quantile=0.9999}.}
}
\value{
A list with the calculated input values for the \code{get_power_cc}
function.
}
\description{
A function that determines the EpipwR inputs (\code{delta_mu}, \code{delta_sd},
\code{det_limit}) for effect-size distribution using pwrEWAS methodology
(Centered at 0, truncated around 0 +/- \code{det_limit} and the 99.99th
percentile of the distribution as \code{maximal_delta}). The output can then
be used as inputs to \code{get_power_cc}.
}
\details{
As described in Graw, et al. (2019), users specify the "maximal delta" and
the detection limit to set the effect size distribution. The purpose of this
function is to provide a map between the pwrEWAS inputs and the EpipwR inputs
to generate the same effect size distribution.

The main purpose of the function is to calculate the standard deviation of
the effect size distribution, since the mean is always 0 and the detection
limit is user-sepcified. Specifically, the standard deviation is calculated
such that the 99.99th percentile of a normal distribution (truncating out
0 +/- \code{det_limit}) is \code{maximal_delta}. For further justification, see Graw,
et al. (2019). Note that this function does allow users to specify quantiles
other than 0.9999. If users wish to use this function for continuous EpipwR,
we recommend specifying a smaller \code{quantile} (i.e., 0.95, 0.99 etc.).
}
\examples{
#This example find the correct EpipwR settings for a maximal (99.99th
#percentile) difference of 0.25 and a dectection limit of .005.
pwrE_to_EpipwR(.25, .005)

}
\references{
Graw, S., Henn, R., Thompson, J. A., and Koestler, D. C. (2019).
pwrEWAS: A user-friendly tool for comprehensive power estimation for
epigenome wide association studies (EWAS). \emph{BMC Bioinformatics},
20(1):218.
}
