% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_power_cc.R
\name{get_power_cc}
\alias{get_power_cc}
\title{Power Calculations for Case/Control EWAS}
\usage{
get_power_cc(
  dm,
  Total,
  n,
  fdr_fwer,
  delta_mu,
  delta_sd = 0,
  n1_prop = 0.5,
  Tissue = "Saliva",
  Nmax = 1000,
  MOE = 0.03,
  test = "pooled",
  use_fdr = TRUE,
  det_limit = 0,
  Suppress_updates = FALSE,
  emp_data = NULL
)
}
\arguments{
\item{dm}{Number of non-null tests.}

\item{Total}{The total number of tests (null and non-null).}

\item{n}{Sample size(s) for which power is calculated (accepts a vector).
This is total sample size.}

\item{fdr_fwer}{Either the false discovery rate or the family-wise type I
error rate, depending on \code{use_fdr}.}

\item{delta_mu}{Average effect size (difference in mean methylation between
groups) for non-null tests (accepts a vector). If multiple \code{n} and
\code{delta_mu} are specified, power is calculated for all unique settings under
the Cartesian product of these vectors.}

\item{delta_sd}{Standard deviation of the effect size for non-null tests.
If 0, all effect sizes are fixed at \code{delta_mu}.}

\item{n1_prop}{Indicates the proportion of the total sample size (\code{n}) in
group 1 (rounded to the nearest integer).}

\item{Tissue}{Tissue type of Empirical EWAS to be used for data generation
(see details for valid options).}

\item{Nmax}{The maximum number of data sets used to calculate power.}

\item{MOE}{The target margin of error of a 95\% confidence interval for
average power. This determines the stopping point of the algorithm.}

\item{test}{The type of t-test to be used. \code{"pooled"} indicates a pooled
variance t-test while \code{"WS"} indicates Welch's t-test.}

\item{use_fdr}{If \code{TRUE}, uses \code{fdr_fwer} as the false discovery rate. If
\code{FALSE}, uses the family-wise type I error rate.}

\item{det_limit}{The minimum mean difference for the effect size
distribution. ignored if \code{delta_sd=0}.}

\item{Suppress_updates}{If \code{TRUE}, blocks messages reporting the completion
of each unique setting.}

\item{emp_data}{Reference data set in matrix or data frame format (Beta
values with CpG sites as rows, samples as columns). Ignored unless
\code{Tissue="Custom"}.}
}
\value{
A dataframe with rows equal to the number of \code{n} and \code{rho_mu}
combinations
}
\description{
Calculates power for EWAS with a binary outcome for multiple
sample sizes and/or effect sizes based on Barth and Reynolds (2025).
Data sets are only simulated for the non-null tests; p-values are generated
directly for the null tests. Rather than specifying the number of data sets
to calculate power, you specify the precision level (\code{MOE})
and a maximum number of data sets (\code{Nmax}). After 20 data sets, the
function terminates when the desired precision level is reached or if the
number of tested data sets reaches \code{Nmax}. Researchers who are familiar with
pwrEWAS can use \code{\link{pwrE_to_EpipwR}} to use pwrEWAS parameterization
in EpipwR.
}
\details{
Valid options for the \code{Tissue} argument are \code{"Saliva"}, \code{"Lymphoma"},
\code{"Placenta"}, \code{"Liver"}, \code{"Colon"}, \code{"Blood adult"}, \code{"Blood 5 year olds"},
\code{"Blood newborns"}, \code{"Cord-blood (whole blood)"}, \code{"Cord-blood (PBMC)"},
\code{"Adult (PBMC)"}, and \code{"Sperm"}. All data sets are publicly available on the
gene expression omnibus (see
\href{https://github.com/jbarth216/EpipwR.data}{EpipwR.data} package for
more details) and were identified by Graw, et al. (2019). Please note that,
due to some extreme values in this data set, the Lymphoma option will
occasionally throw a warning related to data generation. At this time, we
recommend using one of the other tissue options. Users who would like to use
their own reference data set should set \code{Tissue="Custom"} and provide the
data in matrix or data frame format with \code{emp_data}. Users who would like to
take advantage of this setting are responsible for formatting this data set
correctly.

Unlike pwrEWAS (Graw et al., 2019), EpipwR enforces equality of precision
(sum of the parameters) on the distributions of each group rather than
equality of variance.
}
\examples{
# This examples calculates power for 100 non-null tests out of 10,000 total
# with an FDR of 5\%. Sample sizes of 40, 50, 60, 70 and fixed effect sizes
# of 0.01, 0.02, 0.05 are used. For improved accuracy, MOE=.01 to ensure
# that the 95\% confidence interval for average power has a margin of error
# no larger than .01 (unless the maximum of 1,000 data sets is exceeded).
get_power_cc(100,10000,c(40,50,60,70),.05,c(.01,.02,.05), MOE=.01)
}
\references{
Barth, J., and Reynolds, A. W. (2025). EpipwR: Efficient power
analysis for EWAS with continuous outcomes. \emph{Bioinformatics Advances},
5(1), vbaf150.

Graw, S., Henn, R., Thompson, J. A., and Koestler, D. C. (2019).
pwrEWAS: A user-friendly tool for comprehensive power estimation for
epigenome wide association studies (EWAS). \emph{BMC Bioinformatics},
20(1):218.
}
