% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate_gene_expression.R
\name{test_gene_expr}
\alias{test_gene_expr}
\title{The test_gene_expr function}
\usage{
test_gene_expr(
  gene,
  probe,
  DM_values,
  gene.expr.values,
  correlation = "negative"
)
}
\arguments{
\item{gene}{character string indicating a target gene to be modeled.}

\item{probe}{character string indicating a probe mapped to the target gene.}

\item{DM_values}{a vector of DM values for the probe. The names of the element should be sample names.}

\item{gene.expr.values}{a vector of gene expression values for the tested gene. The names of the vector are sample names.}

\item{correlation}{character indicating the direction of correlation between the methylation state of the CpG site and the gene expression levels. Can be either 'negative' or 'positive'.}

\item{raw.pvalue.threshold}{raw p value from testing DNA methylation and gene expression}

\item{adjusted.pvalue.threshold}{adjusted p value from testing DNA methylation and gene expression}
}
\value{
dataframe with functional probe-gene pairs and corresponding p values obtained from the Wilcoxon test for gene expression and methylation.
}
\description{
Helper function to test whether the expression levels of a gene is reversely correlated with the methylation state of a probe.
}
\keyword{internal}
