% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotGene.R
\name{EpiMix_PlotGene}
\alias{EpiMix_PlotGene}
\title{The EpiMix_PlotGene function}
\usage{
EpiMix_PlotGene(
  gene.name,
  EpiMixResults,
  met.platform = "HM450",
  roadmap.epigenome.id = "E002",
  left.gene.margin = 10000,
  right.gene.margin = 10000,
  gene.name.font = 0.7,
  show.probe.name = TRUE,
  probe.name.font = 0.6,
  plot.transcripts = TRUE,
  plot.transcripts.structure = TRUE,
  y.label.font = 0.8,
  y.label.margin = 0.1,
  axis.number.font = 0.5,
  chromatin.label.font = 0.7,
  chromatin.label.margin = 0.02
)
}
\arguments{
\item{gene.name}{character string indicating the name of the gene to be plotted.}

\item{EpiMixResults}{the resulting list object returned from the function of EpiMix.}

\item{met.platform}{character string indicating the type of the microarray where the DNA methylation data were collected. The value should be either 'HM27', 'HM450' or 'EPIC'. Default: 'HM450'}

\item{roadmap.epigenome.id}{character string indicating the epigenome id (EID) for a reference tissue or cell type. Default: 'E002'. If the value is empty (""), no histone modifications plot will show.\
Note: Keep this value empty if using the Windows system, since this feature is not supported in Windows.}

\item{left.gene.margin}{numeric value indicating the number of extra nucleotide bases to be plotted on the left side of the target gene. Default: 10000.}

\item{right.gene.margin}{numeric value indicating the number of extra nucleotide bases to be plotted on the right side of the target gene. Default: 10000.}

\item{gene.name.font}{numeric value indicating the font size for the gene name. Default: 0.7.}

\item{show.probe.name}{logic indicating whether to show the name(s) for each differentially methylated CpG probe. Default: TRUE}

\item{probe.name.font}{numeric value indicating the font size of the name(s) for the differentially methylated probe(s) in pixels. Default: 0.6.}

\item{plot.transcripts}{logic indicating whether to plot each individual transcript of the gene. Default: TRUE. If False, the gene will be plotted with a single rectangle, without showing the structure of individual transcripts.}

\item{plot.transcripts.structure}{logic indicating whether to plot the transcript structure (introns and exons). Non-coding exons are shown in green and the coding exons are shown in red. Default: TRUE.}

\item{y.label.font}{font size of the y axis label}

\item{y.label.margin}{distance between y axis label and y axis}

\item{axis.number.font}{font size of axis ticks and numbers}

\item{chromatin.label.font}{font size of the labels of the histone proteins}

\item{chromatin.label.margin}{distance between the histone protein labels and axis}
}
\value{
plot of the genomic coordinate, DM values and chromatin state for each CpG probe of a specific gene.
}
\description{
plot the genomic coordinate, DM values and chromatin state for each CpG probe of a specific gene.
}
\details{
this function requires R package dependencies: karyoploteR, TxDb.Hsapiens.UCSC.hg19.knownGene, org.Hs.eg.db

roadmap.epigenome.id: since the chromatin state is tissue or cell-type specific,
EpiMix needs to know the reference tissue or cell type in order to retrieve the proper DNase-seq and histone ChIP-seq data.
Available epigenome ids can be obtained from the Roadmap Epigenomic study (Nature, PMID: 25693563, figure 2).
They can also be retrieved from the list.epigenomes() function.
}
\examples{
\donttest{
library(karyoploteR)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(org.Hs.eg.db)
library(regioneR)

data(Sample_EpiMixResults_Regular)

gene.name = 'CCND2'

roadmap.epigenome.id = 'E096'

EpiMix_PlotGene(gene.name = gene.name,
                EpiMixResults = Sample_EpiMixResults_Regular,
                met.platform = 'HM450',
                roadmap.epigenome.id = roadmap.epigenome.id)
}

}
