% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoMetaEfron.R
\name{DoMetaEfron}
\alias{DoMetaEfron}
\title{An R-function to perform a meta-analysis over multiple studies using 
an empirical Bayes procedure by Efron followed by Stouffer method.}
\usage{
DoMetaEfron(stat.m, pval.m, bre = 120, df = 15, pct0 = 0.25, plotlocfdr = 0)
}
\arguments{
\item{stat.m}{A matrix of signed statistics (e.g. t-statistics) with rows labeling genomic 
features (e.g. CpGs or genes) and columns labeling studies. rownames must be 
provided.}

\item{pval.m}{A matrix matched to stat.m containing the associated P-values, with rows 
labeling genomic features (e.g. CpGs or genes) and columns labeling studies.}

\item{bre}{The number of breakpoints to divide statistics per study into bins. By 
default this is 120. See input argument for locfdr function from locfdr 
package.}

\item{df}{The number of degrees of freedom for fitting spline. By default this is 
15. See input argument for locfdr function from locfdr package.}

\item{pct0}{Percentage of statistics to use for fitting null. By default this is 0.25 
(i.e. 25\%).}

\item{plotlocfdr}{Determines whether to plot output or not. By default this is set to 0 meaning
no plot. See input argument for locfdr function from locfdr package.}
}
\value{
meta.m
A matrix with rows as in stat.m, and with 3 columns labeling Stouffer's 
z-statistic, P-value and Benjamini-Hochberg adjusted P-value.
}
\description{
An R-function to perform a meta-analysis over multiple studies using 
an empirical Bayes procedure by Efron followed by Stouffer method.
}
