% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_recall.R
\name{precision_recall}
\alias{precision_recall}
\title{Compute precision-recall}
\usage{
precision_recall(
  peakfiles,
  reference,
  thresholding_cols = c("total_signal", "qValue", "Peak Score"),
  initial_threshold = 0,
  n_threshold = 20,
  max_threshold = 1,
  cast = TRUE,
  workers = 1,
  verbose = TRUE,
  save_path = tempfile(fileext = "precision_recall.csv"),
  ...
)
}
\arguments{
\item{peakfiles}{A list of peak files as GRanges object and/or as paths to
BED files. If paths are provided, EpiCompare imports the file as GRanges
object. EpiCompare also accepts a list containing a mix of GRanges objects
and paths.Files must be listed and named using \code{list()}.
E.g. \code{list("name1"=file1, "name2"=file2)}. If no names are specified,
default file names will be assigned.}

\item{reference}{A named list containing reference peak file(s) as GRanges
 object. Please ensure that the reference file is listed and named
i.e. \code{list("reference_name" = reference_peak)}. If more than one
reference is specified, individual reports for each reference will be
generated. However, please note that specifying more than one reference can
take awhile. If a reference is specified, it enables two analyses: (1) plot
showing statistical significance of overlapping/non-overlapping peaks; and
(2) ChromHMM of overlapping/non-overlapping peaks.}

\item{thresholding_cols}{Depending on which columns are present, 
 \link[GenomicRanges]{GRanges} will 
 be filtered at each threshold according to one or more of the following:
\itemize{
 \item{"total_signal" : }{Used by the peak calling software 
 \href{https://github.com/FredHutch/SEACR}{SEACR}. 
 \emph{NOTE}: Another SEACR column (e.g. "max_signal") can be used 
 together or instead of "total_signal".}
 \item{"qValue"}{Used by the peak calling software 
 \href{https://github.com/macs3-project/MACS}{MACS2/3}. 
 Should contain the negative log of the p-values after multiple 
 testing correction.}
 \item{"Peak Score" : }{
 Used by the peak calling software
  \href{http://homer.ucsd.edu/homer/ngs/peaks.html}{HOMER}.}
}}

\item{initial_threshold}{Numeric threshold that was provided to SEACR 
(via the parameter \code{--ctrl}) when calling peaks without an IgG 
control.}

\item{n_threshold}{Number of thresholds to test.}

\item{max_threshold}{Maximum threshold to test.}

\item{cast}{Cast the data into a format that's more compatible with 
\pkg{ggplot2}.}

\item{workers}{Number of threads to parallelize across.}

\item{verbose}{Print messages.}

\item{save_path}{File path to save precision-recall results to.}

\item{...}{
  Arguments passed on to \code{\link[=bpplapply]{bpplapply}}
  \describe{
    \item{\code{apply_fun}}{Iterator function to use.}
    \item{\code{register_now}}{Register the cores now with
\link[BiocParallel]{register} (\code{TRUE}),
 or simply return the \code{BPPARAM object} (default: \code{FALSE}).}
    \item{\code{use_snowparam}}{Whether to use
\link[BiocParallel]{SnowParam} (default: \code{TRUE}) or
\link[BiocParallel]{MulticoreParam} (\code{FALSE})
 when parallelising across multiple \code{workers}.}
    \item{\code{progressbar}}{
    \code{logical(1)} Enable progress bar (based on plyr:::progress_text).
  }
    \item{\code{X}}{
    Any object for which methods \code{length}, \code{[}, and
    \code{[[} are implemented.
  }
    \item{\code{FUN}}{
    The \code{function} to be applied to each element of \code{X}.
  }
  }}
}
\value{
Overlap
}
\description{
Compute precision and recall using each \link[GenomicRanges]{GRanges}
 object in \code{peakfiles} as the "query" 
 against each \link[GenomicRanges]{GRanges} object in \code{reference}
 as the subject.
}
\examples{
data("CnR_H3K27ac")
data("CnT_H3K27ac")
data("encode_H3K27ac")
peakfiles <- list(CnR_H3K27ac=CnR_H3K27ac, CnT_H3K27ac=CnT_H3K27ac)
reference <- list("encode_H3K27ac" = encode_H3K27ac)

pr_df <- precision_recall(peakfiles = peakfiles,
                          reference = reference,
                          workers = 1)
}
