% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_precision_recall.R
\name{plot_precision_recall}
\alias{plot_precision_recall}
\title{Plot precision-recall curves}
\usage{
plot_precision_recall(
  peakfiles,
  reference,
  thresholding_cols = c("total_signal", "qValue", "Peak Score"),
  initial_threshold = 0,
  n_threshold = 20,
  max_threshold = 1,
  workers = check_workers(),
  plot_f1 = TRUE,
  subtitle = NULL,
  color = "peaklist1",
  shape = color,
  rows = "peaklist2",
  cols = NULL,
  interact = FALSE,
  show_plot = TRUE,
  save_path = tempfile(fileext = "precision_recall.csv"),
  verbose = TRUE
)
}
\arguments{
\item{peakfiles}{A list of peak files as GRanges object and/or as paths to
BED files. If paths are provided, EpiCompare imports the file as GRanges
object. EpiCompare also accepts a list containing a mix of GRanges objects
and paths.Files must be listed and named using \code{list()}.
E.g. \code{list("name1"=file1, "name2"=file2)}. If no names are specified,
default file names will be assigned.}

\item{reference}{A named list containing reference peak file(s) as GRanges
 object. Please ensure that the reference file is listed and named
i.e. \code{list("reference_name" = reference_peak)}. If more than one
reference is specified, individual reports for each reference will be
generated. However, please note that specifying more than one reference can
take awhile. If a reference is specified, it enables two analyses: (1) plot
showing statistical significance of overlapping/non-overlapping peaks; and
(2) ChromHMM of overlapping/non-overlapping peaks.}

\item{thresholding_cols}{Depending on which columns are present, 
 \link[GenomicRanges]{GRanges} will 
 be filtered at each threshold according to one or more of the following:
\itemize{
 \item{"total_signal" : }{Used by the peak calling software 
 \href{https://github.com/FredHutch/SEACR}{SEACR}. 
 \emph{NOTE}: Another SEACR column (e.g. "max_signal") can be used 
 together or instead of "total_signal".}
 \item{"qValue"}{Used by the peak calling software 
 \href{https://github.com/macs3-project/MACS}{MACS2/3}. 
 Should contain the negative log of the p-values after multiple 
 testing correction.}
 \item{"Peak Score" : }{
 Used by the peak calling software
  \href{http://homer.ucsd.edu/homer/ngs/peaks.html}{HOMER}.}
}}

\item{initial_threshold}{Numeric threshold that was provided to SEACR 
(via the parameter \code{--ctrl}) when calling peaks without an IgG 
control.}

\item{n_threshold}{Number of thresholds to test.}

\item{max_threshold}{Maximum threshold to test.}

\item{workers}{Number of threads to parallelize across.}

\item{plot_f1}{Generate a plot with the F1 score vs. threshold as well.}

\item{subtitle}{Plot subtitle.}

\item{color}{Variable to color data points by.}

\item{shape}{Variable to set data point shapes by.}

\item{rows, cols}{A set of variables or expressions quoted by
\code{\link[ggplot2:vars]{vars()}} and defining faceting groups on the rows or columns
dimension. The variables can be named (the names are passed to
\code{labeller}).

For compatibility with the classic interface, \code{rows} can also be
a formula with the rows (of the tabular display) on the LHS and
the columns (of the tabular display) on the RHS; the dot in the
formula is used to indicate there should be no faceting on this
dimension (either row or column).}

\item{interact}{Default TRUE. By default, plots are interactive.
If set FALSE, all plots in the report will be static.}

\item{show_plot}{Show the plot.}

\item{save_path}{File path to save precision-recall results to.}

\item{verbose}{Print messages.}
}
\value{
list with data and precision recall and F1 plots
}
\description{
Plot precision-recall curves (and optionally F1 plots) by
iteratively testing for peak overlap across a series of
thresholds used to filter \code{peakfiles}.
Each \link[GenomicRanges]{GRanges}
 object in \code{peakfiles} will be used as the "query"
 against each \link[GenomicRanges]{GRanges} object in \code{reference}
 as the subject.
 Will automatically use any columns that are
 specified with \code{thresholding_cols} and present within each
 \link[GenomicRanges]{GRanges} object
 to create percentiles  for thresholding.
\emph{NOTE} : Assumes that all \link[GenomicRanges]{GRanges} in
\code{peakfiles} and \code{reference} are already
aligned to the same genome build.
}
\examples{
data("CnR_H3K27ac")
data("CnT_H3K27ac")
data("encode_H3K27ac")
peakfiles <- list(CnR_H3K27ac=CnR_H3K27ac, CnT_H3K27ac=CnT_H3K27ac)
reference <- list("encode_H3K27ac" = encode_H3K27ac)

pr_out <- plot_precision_recall(peakfiles = peakfiles,
                                reference = reference,
                                workers = 1)
}
