% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_files.R
\name{group_files}
\alias{group_files}
\title{Group files}
\usage{
group_files(peakfiles, searches)
}
\arguments{
\item{peakfiles}{A list of peak files as GRanges object and/or as paths to
BED files. If paths are provided, EpiCompare imports the file as GRanges
object. EpiCompare also accepts a list containing a mix of GRanges objects
and paths.Files must be listed and named using \code{list()}.
E.g. \code{list("name1"=file1, "name2"=file2)}. If no names are specified,
default file names will be assigned.}

\item{searches}{A named list of substrings to group \code{peakfiles} by.}
}
\value{
Named peak files
}
\description{
Assign group names to each file in a named list based on a series of string
searches based on combinations of relevant metadata factors.
}
\examples{
data("encode_H3K27ac") # example dataset as GRanges object
data("CnT_H3K27ac") # example dataset as GRanges object
data("CnR_H3K27ac") # example dataset as GRanges object
peakfiles <- list(CnR_H3K27ac=CnR_H3K27ac, 
                  CnT_H3K27ac=CnT_H3K27ac, 
                  encode_H3K27ac=encode_H3K27ac)

peaks_grouped <- group_files(peakfiles = peakfiles,
                             searches=list(assay=c("H3K27ac"),
                                           source=c("Cn","ENCODE")))
}
