% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R, R/sbea.R
\name{eaBrowse}
\alias{eaBrowse}
\alias{ea.browse}
\alias{gsRanking}
\alias{gs.ranking}
\title{Exploration of enrichment analysis results}
\usage{
eaBrowse(
  res,
  nr.show = -1,
  graph.view = NULL,
  html.only = FALSE,
  out.dir = NULL,
  report.name = NULL
)

gsRanking(res, signif.only = TRUE)
}
\arguments{
\item{res}{Enrichment analysis result list (as returned by the functions
\code{\link{sbea}} and \code{\link{nbea}}).}

\item{nr.show}{Number of gene sets to show.  As default all statistically
significant gene sets are displayed.}

\item{graph.view}{Optional.  Should a graph-based summary (reports and
visualizes consistency of regulations) be created for the result?  If
specified, it needs to be a gene regulatory network, i.e. either an absolute
file path to a tabular file or a character matrix with exactly *THREE* cols;
1st col = IDs of regulating genes; 2nd col = corresponding regulated genes;
3rd col = regulation effect; Use '+' and '-' for activation/inhibition.}

\item{html.only}{Logical.  Should the html file only be written (without
opening the browser to view the result page)? Defaults to FALSE.}

\item{out.dir}{Output directory. If \code{NULL}, defaults to a 
timestamp-generated subdirectory of \code{configEBrowser("OUTDIR.DEFAULT")}.}

\item{report.name}{Name of the HTML report. If \code{NULL}, defaults to the
enrichment method used.}

\item{signif.only}{Logical.  Display only those gene sets in the ranking,
which satisfy the significance level? Defaults to TRUE.}
}
\value{
gsRanking: \code{\linkS4class{DataFrame}} with gene sets ranked by
the corresponding p-value;

eaBrowse: none, opens the browser to explore results.

If not instructed otherwise (via argument \code{out.dir}), 
the main HTML report and associated files are written to 
\code{configEBrowser("OUTDIR.DEFAULT")}. 
See \code{?configEBrowser} to change the location. 
If \code{html.only=FALSE}, the HTML report will automatically be opened in 
your default browser.
}
\description{
Functions to extract a flat gene set ranking from an enrichment analysis
result object and to detailedly explore it.
}
\examples{

    
    # real data
    exprs.file <- system.file("extdata/exprs.tab", package="EnrichmentBrowser")
    cdat.file <- system.file("extdata/colData.tab", package="EnrichmentBrowser")
    rdat.file <- system.file("extdata/rowData.tab", package="EnrichmentBrowser")
    probeSE <- readSE(exprs.file, cdat.file, rdat.file)
    geneSE <- probe2gene(probeSE) 
    geneSE <- deAna(geneSE)
    metadata(geneSE)$annotation <- "hsa"

    # artificial enrichment analysis results
    gs <- makeExampleData(what="gs", gnames=names(geneSE))
    ea.res <- makeExampleData(what="ea.res", method="ora", se=geneSE, gs=gs)

    # (5) result visualization and exploration
    gsRanking(ea.res)
 
    out.dir <- configEBrowser("OUTDIR.DEFAULT") 
    eaBrowse(ea.res, out.dir=out.dir, report.name="oraReport")

}
\seealso{
\code{\link{sbea}}, \code{\link{nbea}},
\code{\link{combResults}}
}
\author{
Ludwig Geistlinger
}
