% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deAna.R
\name{deAna}
\alias{deAna}
\alias{de.ana}
\title{Differential expression analysis between two sample groups}
\usage{
deAna(
  expr,
  grp = NULL,
  blk = NULL,
  de.method = c("limma", "edgeR", "DESeq2"),
  padj.method = "BH",
  stat.only = FALSE,
  filter.by.expr = TRUE,
  assay = "auto"
)
}
\arguments{
\item{expr}{Expression data.  A numeric matrix. Rows correspond to genes,
columns to samples.  Alternatively, this can also be an object of class
\code{\linkS4class{SummarizedExperiment}}.}

\item{grp}{*BINARY* group assignment for the samples.  Use '0' and '1' for
unaffected (controls) and affected (cases) samples, respectively.  If NULL,
this is assumed to be defined via a column named 'GROUP' in the
\code{\link{colData}} slot if 'expr' is a
\code{\linkS4class{SummarizedExperiment}}.}

\item{blk}{Optional. For paired samples or sample blocks.  This can also be
defined via a column named 'BLOCK' in the \code{\link{colData}} slot if
'expr' is a \code{\linkS4class{SummarizedExperiment}}.}

\item{de.method}{Differential expression method.  Use 'limma' for microarray
and RNA-seq data.  Alternatively, differential expression for RNA-seq data
can be also calculated using edgeR ('edgeR') or DESeq2 ('DESeq2').  Defaults
to \code{'limma'}.}

\item{padj.method}{Method for adjusting p-values to multiple testing.  For
available methods see the man page of the stats function
\code{\link{p.adjust}}.  Defaults to \code{'BH'}.}

\item{stat.only}{Logical. Should only the test statistic be returned?  This
is mainly for internal use, in order to carry out permutation tests on the
DE statistic for each gene.  Defaults to \code{FALSE}.}

\item{filter.by.expr}{Logical. For RNA-seq data: include only genes with
sufficiently large counts in the DE analysis? If TRUE, excludes genes not 
satisfying a minimum number of read counts across samples using the 
\code{\link{filterByExpr}} function from the edgeR package.
Defaults to TRUE.}

\item{assay}{Character. The name of the assay for differential expression 
analysis if \code{expr} is a \code{\linkS4class{SummarizedExperiment}} with 
*multiple assays*. Defaults to \code{"auto"}, which automatically determines
the appropriate assay based on data type provided and DE method selected. 
See details.}
}
\value{
A DE-table with measures of differential expression for each
gene/row, i.e. a two-column matrix with log2 fold changes in the 1st column
and derived p-values in the 2nd column.  If 'expr' is a
\code{\linkS4class{SummarizedExperiment}}, the DE-table will be
automatically appended to the \code{\link{rowData}} slot.
}
\description{
The function carries out a differential expression analysis between two
sample groups. Resulting fold changes and derived p-values are returned.
Raw p-values are corrected for multiple testing.
}
\details{
Using a \code{\linkS4class{SummarizedExperiment}} with *multiple assays*:

For the typical use case within the EnrichmentBrowser workflow this will
be a \code{\linkS4class{SummarizedExperiment}} with two assays: (i) an assay
storing the *raw* expression values, and (ii) an assay storing the *norm*alized
expression values as obtained with the \code{\link{normalize}} function. 

In this case, \code{assay = "auto"} will *auto*matically determine the assay 
based on the data type provided. For microarray data, differential expression
analysis will be carried out on the assay storing the *norm*alized log2 intensities. 
For RNA-seq data, differential expression analysis will be carried out on the
assay storing the *raw* read counts.

For usage outside of the typical workflow, the \code{assay} argument can be
used to provide the name of the assay for differential expression analysis.
For differential expression analysis of microarray data with 
\code{de.method = "limma"}, this assay should contain the *norm*alized log2 
intensities. For differential expression analysis of RNA-seq data with either
method (limma/voom, edgeR, or DESeq2), the specified assay should contain the
*raw* read counts.
}
\examples{

    # (1) microarray data: intensity measurements
    maSE <- makeExampleData(what = "SE", type = "ma")
    maSE <- deAna(maSE)
    rowData(maSE)
    
    # (2) RNA-seq data: read counts
    rseqSE <- makeExampleData(what = "SE", type = "rseq")
    rseqSE <- deAna(rseqSE, de.method = "DESeq2")
    rowData(rseqSE)

}
\seealso{
\code{\link{readSE}} for reading expression data from file,
\code{\link{normalize}} for normalization of expression data,
\code{\link{voom}} for preprocessing of RNA-seq data, \code{\link{p.adjust}}
for multiple testing correction, \code{\link{eBayes}} for DE analysis with
limma, \code{\link{glmQLFit}} for DE analysis with edgeR, and
\code{DESeq} for DE analysis with DESeq2.
}
\author{
Ludwig Geistlinger
}
