% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebrowser.R
\name{configEBrowser}
\alias{configEBrowser}
\alias{config.ebrowser}
\title{Configuring the EnrichmentBrowser}
\usage{
configEBrowser(key, value = NULL)
}
\arguments{
\item{key}{Configuration parameter.}

\item{value}{Value to overwrite the current value of key.}
}
\value{
If is.null(value) this returns the value of the selected
configuration parameter.  Otherwise, it updates the selected parameter with
the given value.
}
\description{
Function to get and set configuration parameters determining the default
behavior of the EnrichmentBrowser
}
\details{
Important colData, rowData, and result column names: \itemize{ \item
SMPL.COL: colData column storing the sample IDs (default: "SAMPLE") \item
GRP.COL: colData column storing binary group assignment (default: "GROUP")
\item BLK.COL: colData column defining paired samples or sample blocks
(default: "BLOCK")

\item PRB.COL: rowData column storing probe/feature IDs ("PROBEID",
read-only) \item EZ.COL: rowData column storing gene ENTREZ IDs ("ENTREZID",
read-only) \item SYM.COL: rowData column storing gene symbols ("SYMBOL",
read-only) \item GN.COL: rowData column storing gene names ("GENENAME",
read-only)

\item FC.COL: rowData column storing (log2) fold changes of differential
expression between sample groups (default: "FC") \item ADJP.COL: rowData
column storing adjusted (corrected for multiple testing) p-values of
differential expression between sample groups (default: "ADJ.PVAL")

\item GS.COL: result table column storing gene set IDs (default: "GENE.SET")
\item PVAL.COL: result table column storing gene set significance (default:
"PVAL") \item PMID.COL: gene table column storing PUBMED IDs ("PUBMED",
read-only) }

Important URLs (all read-only): \itemize{ \item NCBI.URL:
\url{http://www.ncbi.nlm.nih.gov/} \item PUBMED.URL:
\url{http://www.ncbi.nlm.nih.gov/pubmed/} \item GENE.URL:
\url{http://www.ncbi.nlm.nih.gov/gene/} \item KEGG.URL:
\url{http://www.genome.jp/dbget-bin/} \item KEGG.GENE.URL:
\url{http://www.genome.jp/dbget-bin/www_bget?} \item KEGG.SHOW.URL:
\url{http://www.genome.jp/dbget-bin/show_pathway?} \item GO.SHOW.URL:
\url{http://amigo.geneontology.org/amigo/term/} }

Default output directory: \itemize{ \item EBROWSER.HOME:
\code{tools::R_user_dir("EnrichmentBrowser")} \item OUTDIR.DEFAULT:
\code{file.path(EBROWSER.HOME, "results")} }

Gene set size: \itemize{ \item GS.MIN.SIZE: minimum number of genes per gene
set (default: 5) \item GS.MAX.SIZE: maximum number of genes per gene set
(default: 500) }

Result appearance: \itemize{ \item RESULT.TITLE: (default: "Table of
Results") \item NR.SHOW: maximum number of entries to show (default: 20) }
}
\examples{

    # getting config information
    configEBrowser("GS.MIN.SIZE") 

    # setting config information
    # WARNING: this is for advanced users only!
    # inappropriate settings will impair EnrichmentBrowser's functionality
    configEBrowser(key="GS.MIN.SIZE", value=3)  

    # restoring default config settings     
    configEBrowser() 

}
\author{
Ludwig Geistlinger
}
