% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareMCB.R
\name{CompareMCB}
\alias{CompareMCB}
\title{Compare multiple methylation correlated blocks lists}
\usage{
CompareMCB(
  MCBs,
  method = c("attractors")[1],
  p_value = 0.05,
  min_CpGs = 5,
  platform = "Illumina Methylation 450K"
)
}
\arguments{
\item{MCBs}{Methylation correlated blocks list.}

\item{method}{method used for calculation of differential expression, \cr
should be one of "attractors","t-test". Defualt is "attractors".}

\item{p_value}{p value threshold for the test.}

\item{min_CpGs}{threshold for minimum CpGs must included in the individual MCBs.}

\item{platform}{This parameter indicates the platform used to produce the methlyation profile.}
}
\value{
Object of class \code{list} with elements:
 \tabular{ll}{
   \code{MCBsites} \tab Character set contains all CpG sites in MCBs. \cr
   \code{MCBinformation} \tab Matrix contains the information of results. \cr
 }
}
\description{
This function is used to find the Methylation correlated blocks that differentially expressed between groups. 
This function calculates attractors of all the MCBs among the groups and find the attractor MCBs. \cr
}
\details{
Currently, only illumina 450k platform is supported, the methylation profile need to convert into matrix format.
}
\examples{
data('demo_data',package = "EnMCB")


}
\references{
Xin Yu, De-Xin Kong, EnMCB: an R/bioconductor package for predicting disease progression based on methylation correlated blocks using ensemble models, Bioinformatics, 2021, btab415
}
\author{
Xin Yu
}
