% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarycelltype.R
\name{summarycelltype}
\alias{summarycelltype}
\title{Print test results}
\usage{
summarycelltype(test, results, cluster)
}
\arguments{
\item{test}{"GSEA" or "fisher".}

\item{results}{Annotation results.}

\item{cluster}{Cluster of interest.}
}
\value{
A summary table of a annotation results. 
"core_enrichment" contains markers contributing on the annotation.
}
\description{
This function is used to print summary table of annotation results
 for a specific cluster.
}
\examples{
data(gene_pbmc)
result <- easyct(gene_pbmc, db="cellmarker", species="Human", 
tissue=c("Blood", "Peripheral blood", "Blood vessel",
"Umbilical cord blood", "Venous blood"), p_cut=0.3, test="GSEA", scoretype="pos")
summarycelltype(test="GSEA", results=result, cluster=0)

}
