% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dot.R
\name{plot_dot}
\alias{plot_dot}
\title{Create dot plot for annotation results}
\usage{
plot_dot(test = "GSEA", data)
}
\arguments{
\item{test}{Test used to annotate cell types: "GSEA" or "fisher"}

\item{data}{Annotation results}
}
\value{
A dot plot showing the top 5 significant cell types for each cluster.
}
\description{
This function is used to generate a dor plot presenting the top 5
candidate cell types for each cluster.
}
\examples{
data(gene_pbmc)
result <- easyct(gene_pbmc, db="cellmarker", species="Human", 
tissue=c("Blood", "Peripheral blood", "Blood vessel",
"Umbilical cord blood", "Venous blood"), p_cut=0.3, test="GSEA", scoretype="pos")
plot_dot("GSEA", result)

}
