% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_limma.r
\name{run_limma}
\alias{run_limma}
\title{Run DGE: \pkg{limma}}
\usage{
run_limma(exp, level2annot, mtc_method = "BH", verbose = TRUE, ...)
}
\arguments{
\item{exp}{Expression matrix with gene names as rownames.}

\item{level2annot}{Array of cell types, with each sequentially corresponding
a column in the expression matrix.}

\item{mtc_method}{Multiple-testing correction method used by DGE step.
See \link[stats]{p.adjust} for more details.}

\item{verbose}{Print messages.
#' @inheritParams orthogene::convert_orthologs}

\item{...}{Additional arguments to be passed to
\link[gprofiler2]{gorth} or \link[homologene]{homologene}.\cr\cr
\emph{NOTE}: To return only the most "popular"
interspecies ortholog mappings,
supply \code{mthreshold=1} here AND set \code{method="gprofiler"} above.
This procedure tends to yield a greater number of returned genes but at
 the cost of many of them not being true biological 1:1 orthologs.\cr\cr
 For more details, please see
\href{https://cran.r-project.org/web/packages/gprofiler2/vignettes/gprofiler2.html}{
 here}.}
}
\value{
\code{limma} results.
}
\description{
Run Differential Gene Expression with \pkg{limma}.
}
\keyword{internal}
